package com.digiwin.athena.executionengine.enumtype;

/**
 * @description: action Type 枚举类型
 * @author: renwm
 * @date: 2020/6/12 17:36
 */
public enum ActionTypeEnum {

    /**
     * bpm
     */
    TASK("START_PROCESS", "TaskAction", "工作流"),
    START_SC("START_SC", "TaskAction", "服务编排"),

    START_TASK("START_TASK", "TaskAction", "发起工作流"),

    /**
     * script
     */
    FORMULA("FORMULA", "FormulaAction", "计算"),
    FORMULA_C("FORMULAC", "FormulaCAction", "计算"),
    /**
     * esp
     */
    ESP("ESP", "EspAction", "服务池"),
    /**
     * getVar
     */
    GET_VAR("GET_VAR", "MechanismAction", "求取机制变量"),

    IAM("IAM", "IamAction", "IAM"),
    EOC("EOC", "EocAction", "EOC"),

    ATHENA("ATHENA", "AthenaAction", "Athena内部"),
    X("TRANS", "TransAction", "Trans"),

    DATA_EVENT("START_DATAEVENT", "DataEventAction", "任务引擎"),

    SERVICE_COMPOSER("START_SERVICECOMPOSER", "ServiceComposerAction", "服务编排"),

    PULL_DATA("PULL_DATA", "PullDataAction", "pull_data"),

    THIRD_PARTY("THIRD_PARTY", "ThirdPartyAction", "调用第三方API"),

    BMD_GENERAL_ACTION("BMD_GENERAL","BMDGeneralAction","业务中台通用API"),

    MICRO_TRANS_ACTION("MICRO_TRANS","MicroTransAction","micro_trans"),

    BMD_ACTION("BMD","BMD","临时"),
    SQL_ACTION("SQL","SqlAction","sql_action"),
    BMD_API_ACTION("BMD_API","BmdApiAction","业务中台api"),
    METRIC("METRIC","MetricAction","指标Action"),
    INPUT("INPUT","InputAction","输入action"),
    BIZ_PARAM("BIZ_PARAM","BizParamAction","业务参数action"),
    /**
     * 未知类型
     */
    UNKNOWN("UNKNOWN", "", "未知类型");

    String type;
    String desc;
    String className;

    ActionTypeEnum(String type, String className, String desc) {
        this.type = type;
        this.className = className;
        this.desc = desc;
    }

    public static ActionTypeEnum getEnumByType(String type) {
        for (ActionTypeEnum itemEnum : ActionTypeEnum.values()) {

            if (itemEnum.getType().equals(type)) {
                return itemEnum;
            }
        }
        return UNKNOWN;
    }

    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getClassName() {
        return className;
    }
}
