package com.digiwin.athena.executionengine.enumtype;

/**
 * @description: 返回结果类型枚举定义
 * @author: renwm
 * @date: 2020/6/22 15:40
 */
public enum ResultTypeEnum {

    /**
     * 参数错误
     */
    PARAM_ERROR(false, "参数错误"),

    /**
     * 调用服务成功
     */
    EXECUTE_RESULT_SUCCESS(true, "执行引擎调用服务成功"),

    /**
     * 调用服务失败
     */
    EXECUTE_RESULT_FAILED(false, "执行引擎调用服务失败");


    private Boolean status;
    private String msg;

    ResultTypeEnum(Boolean status, String msg) {

        this.status = status;
        this.msg = msg;
    }


    public Boolean getStatus() {
        return status;
    }

    public String getMsg() {
        return msg;
    }
}
