package com.digiwin.athena.executionengine.model;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


/**
 * @author wuyang
 */
public class DataDescription implements Serializable {

    private static final long serialVersionUID = -7273480390869675483L;

    private List<DataItem> dataItems = new ArrayList<>();

    private List<String> dimensions = new ArrayList<>();

    /**
     * 行权限字段 对应鼎捷云种传入的row 结构信息
     */
    private JSONObject permissions = new JSONObject();

    private JSONArray datasetPermissions = new JSONArray();

    public JSONArray getDatasetPermissions() {
        return datasetPermissions;
    }

    public void setDatasetPermissions(JSONArray datasetPermissions) {
        this.datasetPermissions = datasetPermissions;
    }

    private JSONObject dynamicSchema = new JSONObject();
    /**
     * 多产品线 dbType
     * [{
     * "productCode":"sMes",///产品线是ERP的话就是E10，WF等
     * "productLine":"MES",
     * "dbType":"sqlServer"
     * <p>
     * <p>
     * }]
     */
    private JSONArray productLineInfo = new JSONArray();

    /**
     * [
     * {
     * "productCode":"sMes",///产品线是ERP的话就是E10，WF等
     * "productLine":"MES",
     * "row":{}
     * },
     * {
     * "productCode":"E10",///产品线是ERP的话就是E10，WF等
     * "productLine":"E10",
     * "row":{}
     * }
     * ]
     * 多产品线 行权限
     */
    private JSONArray productLineRows = new JSONArray();

    public JSONArray getProductLineRows() {
        return productLineRows;
    }

    public void setProductLineRows(JSONArray productLineRows) {
        this.productLineRows = productLineRows;
    }

    /**
     * 是否为数据集
     */
    private boolean dataset = false;

    public boolean isDataset() {
        return dataset;
    }

    public void setDataset(boolean dataset) {
        this.dataset = dataset;
    }

    public JSONArray getProductLineInfo() {
        return productLineInfo;
    }

    public void setProductLineInfo(JSONArray productLineInfo) {
        this.productLineInfo = productLineInfo;
    }

    public JSONObject getDynamicSchema() {
        return dynamicSchema;
    }

    public void setDynamicSchema(JSONObject dynamicSchema) {
        this.dynamicSchema = dynamicSchema;
    }

    public JSONObject getPermissions() {
        return permissions;
    }

    public void setPermissions(JSONObject permissions) {
        this.permissions = permissions;
    }

    public List<DataItem> getDataItems() {
        return dataItems;
    }

    public void setDataItems(List<DataItem> dataItems) {
        this.dataItems = dataItems;
    }

    public List<String> getDimensions() {
        return dimensions;
    }

    public void setDimensions(List<String> dimensions) {
        this.dimensions = dimensions;
    }
}
