package com.digiwin.athena.executionengine.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;

import java.io.Serializable;

/**
 * @description: 侦测引擎响应对象
 * @author: renwm
 * @date: 2020/4/27 10:16
 */
public class ServiceResult  implements Serializable {


    private static final long serialVersionUID = -6438031312852569104L;
    /**
     * 服务返回的消息
     */
    private String message;

    private Boolean success;

    private Object data;

    public ServiceResult() {

    }

    public ServiceResult(Boolean success) {
        this.success = success;
    }
    public ServiceResult(Boolean success,String message)
    {
        this.success=success;
        this.message=message;
    }
    public ServiceResult(Boolean success,String message,Object data) {
        this.success = success;
        this.message = message;
        this.data = data;
    }



    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this, SerializerFeature.WRITE_MAP_NULL_FEATURES);
    }
}
