package com.digiwin.athena.executionengine.model.trans;

import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author wuyang
 */
public class MicroTrans implements Serializable {
    private static final long serialVersionUID = 5886101496564875313L;

    /**
     * 版本
     */
    private String version = "2";
    /**
     * trans规则定义中的两个部分，order和step实体对象集合
     */
    private List<StepElement> step;
    /**
     * OrderElement 集合
     */
    private List<OrderElement> order;

    public MicroTrans() {
    }

    public MicroTrans(List<StepElement> step, List<OrderElement> order) {
        this.step = step;
        this.order = order;
    }

    public MicroTrans(String version, List<StepElement> step, List<OrderElement> order) {
        this.version = version;
        this.step = step;
        this.order = order;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public List<StepElement> getStep() {
        return step;
    }

    public void setStep(List<StepElement> step) {
        this.step = step;
    }

    public List<OrderElement> getOrder() {
        return order;
    }

    public void setOrder(List<OrderElement> order) {
        this.order = order;
    }

    public static List<OrderElement> buildOrderListByStepList(List<StepElement> stepElementList){
        if(CollectionUtils.isEmpty(stepElementList) || stepElementList.size() == 1){
            return Collections.EMPTY_LIST;
        }
        List<OrderElement> orders = new ArrayList<>(stepElementList.size() - 1);
        for(int i=1;i< stepElementList.size(); i++){
            OrderElement orderElement = new OrderElement();
            if(i == 1){
                orderElement.setFrom(stepElementList.get(0).getName());
                orderElement.setTo(stepElementList.get(i).getName());
            }else {
                orderElement.setFrom(stepElementList.get(i-1).getName());
                orderElement.setTo(stepElementList.get(i).getName());
            }
            orders.add(orderElement);
        }
        return orders;
    }
}
