package com.digiwin.athena.executionengine.model.trans.components;

/**
 * @description: 计算规则
 * @author: fenglei
 * @date: 2021-1-5
 */
public class CalculateRuleDto {

    /**
     * 计算器算法类型
     */
    String calcType;

    /**
     * 算法参数A
     */
    String fieldA;

    /**
     * 算法参数B
     */
    String fieldB;

    /**
     * 算法参数C
     */
    String fieldC;

    /**
     * 参数A字符串格式化结构
     */
    String formatA;

    /**
     * 参数B字符串格式化结构
     */
    String formatB;

    /**
     * 参数C字符串格式化结构
     */
    String formatC;

    /**
     * 算法参数A来源 column or constant
     */
    String fieldAType;

    /**
     * 算法参数B来源 column or constant
     */
    String fieldBType;

    /**
     * 算法参数C来源 column or constant
     */
    String fieldCType;

    public String getFieldAType() {
        return fieldAType;
    }

    public void setFieldAType(String fieldAType) {
        this.fieldAType = fieldAType;
    }

    public String getFieldBType() {
        return fieldBType;
    }

    public void setFieldBType(String fieldBType) {
        this.fieldBType = fieldBType;
    }

    public String getFieldCType() {
        return fieldCType;
    }

    public void setFieldCType(String fieldCType) {
        this.fieldCType = fieldCType;
    }

    /**
     * 节点计算最终结果存储字段的字段名
     */
    String newField;

    /**
     * 节点计算最终结果的数据类型
     */
    String valueType;

    /**
     * 节点计算最终结果的数据长度，超过长度会截断（暂未启用）
     */
    String valueLength;

    /**
     * 节点计算最终结果的数据精度，超过长度会截断（暂未启用）
     * 并不是向下取整，而是截断
     */
    String precision;

    /**
     * 输出结果中是否保留该字段
     */
    String retain;

    /**
     * 间隔天数
     */
    private int intervalDays;

    /**
     * 取整类型
     * 向上取整、向下取整、四舍五入
     */
    private String precisionType;

    /**
     * 数据运算逻辑异常的做法
     * 比如：除法分母为0时
     */
    private String exceptionHandling;

    /**
     * 后缀 date  会自动将日期类型数据 2023-01-01 转换为 2023年-01月-01日
     */
    private String suffix;

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getPrecisionType() {
        return precisionType;
    }

    public void setPrecisionType(String precisionType) {
        this.precisionType = precisionType;
    }

    public int getIntervalDays() {
        return intervalDays;
    }

    public void setIntervalDays(int intervalDays) {
        this.intervalDays = intervalDays;
    }

    public String getCalcType() {
        return calcType;
    }

    public void setCalcType(String calcType) {
        this.calcType = calcType;
    }

    public String getFieldA() {
        return fieldA;
    }

    public void setFieldA(String fieldA) {
        this.fieldA = fieldA;
    }

    public String getFieldB() {
        return fieldB;
    }

    public void setFieldB(String fieldB) {
        this.fieldB = fieldB;
    }

    public String getFieldC() {
        return fieldC;
    }

    public void setFieldC(String fieldC) {
        this.fieldC = fieldC;
    }

    public String getFormatA() {
        return formatA;
    }

    public void setFormatA(String formatA) {
        this.formatA = formatA;
    }

    public String getFormatB() {
        return formatB;
    }

    public void setFormatB(String formatB) {
        this.formatB = formatB;
    }

    public String getFormatC() {
        return formatC;
    }

    public void setFormatC(String formatC) {
        this.formatC = formatC;
    }

    public String getNewField() {
        return newField;
    }

    public void setNewField(String newField) {
        this.newField = newField;
    }

    public String getValueType() {
        return valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getValueLength() {
        return valueLength;
    }

    public void setValueLength(String valueLength) {
        this.valueLength = valueLength;
    }

    public String getPrecision() {
        return precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public String getRetain() {
        return retain;
    }

    public void setRetain(String retain) {
        this.retain = retain;
    }

    public String getExceptionHandling() {
        return exceptionHandling;
    }

    public void setExceptionHandling(String exceptionHandling) {
        this.exceptionHandling = exceptionHandling;
    }
}
