package com.digiwin.athena.executionengine.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWService;
import com.digiwin.athena.executionengine.dto.ExportDataDto;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.vo.MetricResultVo;

import java.util.List;
import java.util.Map;


/**
 * @description:
 * @author: renwm
 * @date: 2020/5/18 13:53
 */
public interface IExecuteService extends DWService {

    /**
     * 执行外部服务
     *
     * @param tenantId
     * @param actionId
     * @param paras
     * @return
     * @
     */
    Object post(String tenantId, String actionId, List<Map<String, Object>> paras);

    /**
     * 调用执行引擎服务接口
     *
     * @param tenantId
     * @param actionId
     * @param param
     * @return
     * @
     */
    Object post(String tenantId, String actionId, Map<String, Object> param);

    /**
     * 调用执行引擎服务接口
     *
     * @param tenantId
     * @param actionId
     * @param paras
     * @param eocMap
     * @return
     * @
     */
    Object post(String tenantId, String actionId, List<Map<String, Object>> paras, Map<String, Object> eocMap);

    /**
     * 调用执行引擎服务接口
     *
     * @param tenantId
     * @param actionId
     * @param param
     * @param eocMap
     * @return
     * @
     */
    Object post(String tenantId, String actionId, Map<String, Object> param, Map<String, Object> eocMap);

    /**
     * 调用执行引擎服务接口
     *
     * @param actionId
     * @param param
     * @param eocMap
     * @param sysParam
     * @return
     * @
     */
    Object post(String tenantId, String actionId, Map<String, Object> param, Map<String, Object> eocMap, Map<String, Object> sysParam);


    /**
     * 调用执行引擎服务接口
     *
     * @param actionId
     * @param param
     * @param eocMaps
     * @param sysParam
     * @return
     * @
     */
    Object post(String tenantId, String actionId, Map<String, Object> param, List<Map<String, Object>> eocMaps, List<String> roles,
                Map<String, Object> sysParam, DataDescription dataDescription);


    /**
     * 调用执行引擎服务接口获取指标数据
     *
     * @param actionId
     * @param param
     * @param eocMaps
     * @param sysParam
     * @return
     * @
     */
    MetricResultVo postQueryMetric(String tenantId, String actionId, Map<String, Object> param, List<Map<String, Object>> eocMaps, List<String> roles,
                                   Map<String, Object> sysParam, DataDescription dataDescription);

    /**
     * 调用执行引擎服务接口
     *
     * @param tenantId
     * @param actionId
     * @param paras
     * @param eocMap
     * @param sysParam
     * @return
     * @
     */
    Object post(String tenantId, String actionId, List<Map<String, Object>> paras, Map<String, Object> eocMap, Map<String, Object> sysParam);

    /**
     * 通过执行引擎生成数据的元数据，使用dataMapping的能力
     *
     * @param data     //需要生成元数据的数据
     * @param actionId //用于比较的元数据
     * @param tenantId
     * @return
     * @
     */
    Object post(Object data, String actionId, String tenantId);


    /**
     * mockData接口
     *
     * @param tenantId
     * @param actionId
     * @param param
     * @param eocMap
     * @param sysParam
     * @param mockData
     * @return
     */
    Object post(String tenantId, String actionId, Map<String, Object> param, Map<String, Object> eocMap,
                Map<String, Object> sysParam, Map<String, Object> mockData);


    /**
     * 指标明细导出---旧
     *
     * @param tenantId
     * @param eocMaps
     * @param sysParam
     * @param solutionStep
     * @param permissions
     * @return
     */
    List<ExportDataDto> postExport(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, Map<String, Object> permissions);

    /**
     * 新架构取数---旧
     *
     * @param tenantId
     * @param eocMaps
     * @param sysParam
     * @param solutionStep
     * @param permissions
     * @return
     */
    Object post(String tenantId, List<Map<String, Object>> eocMaps,
                Map<String, Object> sysParam, JSONArray solutionStep, Map<String, Object> permissions);

    /**
     * 指标明细导出---多产品线
     *
     * @param tenantId
     * @param eocMaps
     * @param sysParam
     * @param solutionStep
     * @param extension
     * @return
     */
    List<ExportDataDto> postExport(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, JSONObject extension);

    /**
     * 新架构取数---多产品线
     *
     * @param tenantId
     * @param eocMaps
     * @param sysParam
     * @param solutionStep
     * @param extension
     * @return
     */
    Object post(String tenantId, List<Map<String, Object>> eocMaps, Map<String, Object> sysParam, JSONArray solutionStep, JSONObject extension);
}
