package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/24
 */
@Service
public class GroupTransformer implements ICriteriaTransformer {
    @Override
    public JSONObject analysisVariable(JSONObject schema) {
        JSONObject variable = new JSONObject();
        variable.put("technique", "group");
        variable.put("groupFields", schema.getJSONArray("groupFields"));
        variable.put("distinctFields", schema.getJSONArray("distinctFields"));
        JSONArray statistics = new JSONArray();
        variable.put("statistics", statistics);

        JSONArray functionFields = schema.getJSONArray("functionFields");
        functionFields.stream().forEach(item -> {
            JSONObject itemObj = (JSONObject) item;
            JSONObject statisticsItem = new JSONObject();
            statisticsItem.put("statisticalFields", itemObj.getJSONArray("fields"));
            statisticsItem.put("statisticalMethod", itemObj.getString("method"));
            statisticsItem.put("newField", itemObj.getString("newFields"));
            statisticsItem.put("type", itemObj.getString("valueType"));
            statistics.add(statisticsItem);
        });

        return variable;
    }
}
