package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

import java.util.ArrayList;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/24
 */
@Service
public class LimitTransformer implements ICriteriaTransformer {
    @Override
    public JSONObject analysisVariable(JSONObject schema) {
        JSONObject variable = new JSONObject();
        variable.put("technique", "limit");
        variable.put("fields", new ArrayList<>());
        JSONArray statistic = new JSONArray();

        JSONObject statisticItem = new JSONObject();
        statisticItem.put("statisticalMethod", "limit");
        statisticItem.put("startPos", schema.getIntValue("startPos"));
        statisticItem.put("endPos", schema.getIntValue("endPos"));
        statistic.add(statisticItem);
        variable.put("statistics", statistic);

        return variable;
    }
}
