package com.digiwin.athena.executionengine.service.facade.event;

import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.execution.asyc.AsyncExecutor;
import com.digiwin.athena.executionengine.util.ContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.Optional;
import java.util.Set;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/5/20
 */
@Service
public class ActionEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutor.class);

    @EventListener
    public void handleActionEvent(ActionEvent event) {
        String source = event.getActionId();
        ExecuteContext context = event.getContext();
        Set<String> pActionIds = context.getActionQueue().getNode(source);

        Map<String, String> line = context.getLine();
        String pre = line.get(source);


        pActionIds.forEach(k -> {
            String tempLine;
            if (pre == null) {
                tempLine = source + "--->" + k;
            } else {
                tempLine = pre + "--->" + k;
            }
            line.put(k, tempLine);
            LOGGER.info("stepLine:{}", tempLine);
            ActionBase actionBase = Optional.ofNullable(context.getActionParam(k)).map(ap ->
                    ContextUtils.getBean(ap.getActionName(), ActionBase.class)).orElse(null);
            actionBase.prepare(context, context.getActionParam(k));
        });
        if (CollectionUtils.isEmpty(pActionIds)) {
            synchronized (context) {
                context.notify();
            }
        }


    }
}

