package com.digiwin.athena.executionengine.service.facade.execution.asyc;

import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ResultStatusConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/5/20
 */
public class AsyncTask {

    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTask.class);
    private ActionParam actionParam;

    private volatile ExecuteContext context;

    private boolean canExec = true;


    public AsyncTask(ExecuteContext context, ActionParam actionParam) {
        this.context = context;
        this.actionParam = actionParam;
    }

    public AsyncTask(ExecuteContext context, ActionParam actionParam, boolean canExec) {
        this.context = context;
        this.actionParam = actionParam;
        this.canExec = canExec;
    }


    public void exec() {

        if (!canExec) {
            actionParam.setActionState(ResultStatusConstant.EXECUTE_FAILD.getCode());
            LOGGER.info("{} 不能执行，默认失败:{}", actionParam.getActionId(), actionParam.getActionState());
            return;
        }

        ActionBase actionBase = Optional.ofNullable(context.getActionParam(actionParam.getActionId())).map(ap ->
                ContextUtils.getBean(ap.getActionName(), ActionBase.class)).orElse(null);
        if (null == actionBase) {
            throw ExceptionUtils.buildBusinessException(ErrorCodeEnum.ACTION_NOT_FOUND, actionParam.getActionId());
        }
        try {
            boolean flag = actionBase.exec(context, actionParam);
            LOGGER.info("--actionId:{}----------exec-----------{}", actionParam.getActionId(), flag);
            if (flag) {
                actionParam.setActionState(ResultStatusConstant.EXECUTE_SUCCESS.getCode());
            } else {
                //更新actionState状态
                actionParam.setActionState(ResultStatusConstant.EXECUTE_FAILD.getCode());
            }
        } catch (Exception e) {
            LOGGER.error("--actionId:{}----------exec-------excetion", actionParam.getActionId(), e);
            actionParam.setActionState(ResultStatusConstant.EXECUTE_FAILD.getCode());
        }

        LOGGER.info("{} 执行完成，执行结果:{}", actionParam.getActionId(), actionParam.getActionState());
    }

    public ExecuteContext getExecuteContext() {
        return context;
    }

    public ActionParam getActionParam() {
        return actionParam;
    }
}
