package com.digiwin.athena.executionengine.service.facade.mapping.test;

import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case1;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case2;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case3;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case4;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case5;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case6;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case8;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case9;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CasePack.Case7;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;

/**
 * @description:
 * @author: fenglei
 * @date: 2020-11-13
 */
public class TestEnter {
    public ExecuteContext context;
    public DataMappingManager dataMappingManager;

    TestEnter() {
        this.context = new ExecuteContext();
        this.dataMappingManager
                = new DataMappingManager(context.getActionResponse(), context.getInputParam());
    }

    /**
       测试时，只要在testpack中新建test数据类，在main里面创建就可以了
       然后创建新的testHandler，直接run即可

       Case1 test1 = new Case1();
        DataMappingTestUtil test1Handler = new DataMappingTestUtil(test1.testData,
                testEnter.context, testEnter.dataMappingManager);
        test1Handler.run();
     */
    public static void main(String[] args) {
        TestEnter testEnter = new TestEnter();

        //case1
        Case1 case1 = new Case1();
        DataMappingTestUtil test1Handler = new DataMappingTestUtil(case1.testData,
                testEnter.context, testEnter.dataMappingManager);
        test1Handler.runGetDataMappingHandler();

        //case2
        Case2 case2 = new Case2();
        DataMappingTestUtil test2Handler = new DataMappingTestUtil(case2.testData,
                testEnter.context, testEnter.dataMappingManager);
        test2Handler.runGetJsonByParamPath();

        //case3
        Case3 case3 = new Case3();
        DataMappingTestUtil test3Handler = new DataMappingTestUtil(case3.testData,
                testEnter.context, testEnter.dataMappingManager);
        test3Handler.runNext(9);
        test3Handler.runGetJsonByParamPath();

        //case4
        Case4 case4 = new Case4();
        DataMappingTestUtil test4Handler = new DataMappingTestUtil(case4.testData,
                testEnter.context, testEnter.dataMappingManager);
        test4Handler.runNext(3);
        test4Handler.runGetZoneDataSize();

        //case5
        Case5 case5 = new Case5();
        DataMappingTestUtil test5Handler = new DataMappingTestUtil(case5.testData,
                testEnter.context, testEnter.dataMappingManager);
        test5Handler.runGetPathDataSize();

        //case6
        Case6 case6 = new Case6();
        DataMappingTestUtil test6Handler = new DataMappingTestUtil(case6.testData,
                testEnter.context, testEnter.dataMappingManager);
        test6Handler.runGetPathDataSize();

        //case7
        Case7 case7 = new Case7();
        DataMappingTestUtil test7Handler = new DataMappingTestUtil(case7.testData,
                testEnter.context, testEnter.dataMappingManager);
        test7Handler.runCountCollectionInPath();

        //case8
        Case8 case8 = new Case8();
        DataMappingTestUtil test8Handler = new DataMappingTestUtil(case8.testData,
                testEnter.context, testEnter.dataMappingManager);
        test8Handler.runGetCollectionParamPathList();

        //case9
        Case9 case9 = new Case9();
        DataMappingTestUtil test9Handler = new DataMappingTestUtil(case9.testData,
                testEnter.context, testEnter.dataMappingManager);
        test9Handler.runGetZoneDataSizeByJpath();
    }
}
