package com.digiwin.athena.executionengine.service.facade.schema.datacenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.dto.schema.DateFormatDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/13
 */
@Service
public class DataCenterGroupConvertor extends AbstractSchemaConvertor {

    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        Object dynamicSchema = schemaTransDto.getDynamicSchema();
        if (dynamicSchema == null) {
            return;
        }
        JSONArray groups = (JSONArray) dynamicSchema;

        if (CollectionUtils.isEmpty(groups)) {
            return;
        }

        JSONObject mappingFields = (JSONObject) schemaTransDto.getReqData();

        //排除计算列的groups
        List<JSONObject> exclusionCalNodes = groups.stream().map(o -> (JSONObject) o).filter(item -> !FieldNameConstant.DYNAMIC_SCHEMA_CALCULATE.equals(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT_TYPE))).collect(Collectors.toList());

        handleGroup(querySchema, exclusionCalNodes, mappingFields);

        //需要处理计算列
        List<JSONObject> calculateObj = groups.stream().map(o -> (JSONObject) o).filter(item -> FieldNameConstant.DYNAMIC_SCHEMA_CALCULATE.equals(item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT_TYPE))).collect(Collectors.toList());

        if (CollectionUtils.isEmpty(calculateObj)) {
            return;
        }

        JSONObject computeObj = schemaTransDto.getComputeObj();

        List<DateFormatDto> dateFormatDtos = new ArrayList<>();
        calculateObj.forEach(item -> {
            String content = item.getString(FieldNameConstant.DYNAMIC_SCHEMA_CONTENT);
            JSONArray computeList = computeObj.getJSONArray(content);
            if (CollectionUtils.isEmpty(computeList)) {
                return;
            }

            computeList.forEach(o -> {
                JSONObject computeItem = (JSONObject) o;
                String calFunction = computeItem.getString("calFunction");
                //只处理日期类型
                if ("DateFormat".equals(calFunction)) {
                    JSONArray params = computeItem.getJSONArray("params");
                    JSONObject fieldParam = params.getJSONObject(0);
                    JSONObject formatParam = params.getJSONObject(1);

                    String field = fieldParam.getString("content");
                    String fieldType = fieldParam.getString("dataType");
                    String format = formatParam.getString("content");
                    DateFormatDto dateFormatDto = new DateFormatDto(field, CommonConstant.DATA_CENTER_FUNCTION_MAP.get(format));
                    dateFormatDto.setFieldType(fieldType);
                    dateFormatDtos.add(dateFormatDto);
                }
            });
        });

        if (CollectionUtils.isNotEmpty(dateFormatDtos)) {
            //拼接computeList
            dateFormatDtos.forEach(dateFormatDto -> {
                JSONObject computeObject = new JSONObject();
                computeObject.put("field", dateFormatDto.getField());
                computeObject.put("dataType", dateFormatDto.getFieldType().toUpperCase());
                computeObject.put("expression", "date_format([" + mappingFields.getString(dateFormatDto.getField()) + "],'" + dateFormatDto.getFormat() + "')");
                querySchema.getJSONArray("computedFields").add(computeObject);


                //也需要拼接到group中
                JSONObject groupObject = new JSONObject();
                //需要和computeFields保持一致
                groupObject.put("field", dateFormatDto.getField());
                groupObject.put("name", dateFormatDto.getField());
                groupObject.put("dataType", dateFormatDto.getFieldType().toUpperCase());
                if (!dimensionsIsExist(querySchema, dateFormatDto.getField())) {
                    querySchema.getJSONArray("dimensions").add(groupObject);
                }
            });
        }

    }

    /**
     * 处理group节点
     *
     * @param querySchema
     * @param exclusionCalNodes
     * @param mappingFields
     */
    private void handleGroup(JSONObject querySchema, List<JSONObject> exclusionCalNodes, JSONObject mappingFields) {
        exclusionCalNodes.forEach(obj -> {
            String dataType = obj.getString("dataType");
            String content = obj.getString("content");
            JSONObject groupObject = new JSONObject();
            groupObject.put("field", mappingFields.getString(content));
            groupObject.put("name", content);
            groupObject.put("dataType", dataType.toUpperCase());
            if (!dimensionsIsExist(querySchema, content)) {
                querySchema.getJSONArray("dimensions").add(groupObject);
            }
        });
    }


}
