package com.digiwin.athena.executionengine.util;

import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/12 16:50
 */
public class ClassUtils {
    private static final String ACTION_PACKAGE_NAME = "com.digiwin.athena.executionengine.component.action.";
    private static final String PARAM_PACKAGE_NAME = "com.digiwin.athena.executionengine.component.param.";

    /**
     * 获取Action对象实例
     *
     * @param className
     * @return
     * @throws Exception
     */
    public static ActionBase getActionInstance(String className) throws Exception {
        Object cls = newInstance(StringUtils.join(ACTION_PACKAGE_NAME, className));
        return Optional.ofNullable(cls).map(clss -> (ActionBase) clss).orElse(null);
    }

    /**
     * 获取参数对象实例
     *
     * @param className
     * @return
     * @throws Exception
     */
    public static ParamBase getParamInstance(String className) throws Exception {
        Object cls = newInstance(StringUtils.join(PARAM_PACKAGE_NAME, className));
        return Optional.ofNullable(cls).map(clss -> (ParamBase) clss).orElse(null);
    }

    /**
     * 获取类对象实例
     *
     * @param className
     * @return
     * @throws Exception
     */
    public static Object newInstance(String className) throws Exception {
        if (StringUtils.isBlank(className)) {
            return null;
        }
        return Class.forName(className).newInstance();
    }
}
