package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.app.serviceclient.ServiceClient;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.model.espsdk.EspSdkReqParam;
import com.digiwin.athena.smartdata.sdk.InvokerProxy;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @description: 调用平台服务帮助类
 * @author: renwm
 * @date: 2020/4/26 15:59
 */
public class PlatformServiceUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformServiceUtils.class);

    private PlatformServiceUtils() {
    }

    /**
     * 获取平台 ServiceClient
     *
     * @return
     */
    public static ServiceClient getServiceClient() {
        return new ServiceClient();
    }


    public static String invokeOtherService(String apName, String moduleName, String serviceName, String methodName, Map<String, Object> parameter) throws Exception {
        ServiceClient serviceClient = getServiceClient();
        return serviceClient.invokeOtherDapService(apName, moduleName, serviceName, methodName, parameter);
    }


    /**
     * 获取租户对应的授权码
     *
     * @param tenantId
     * @return
     */
    public static String getTenantSecretKey(String tenantId) throws Exception {
        Map<String, Object> licenseKeyParam = licenseKeyParam(tenantId);
        LOGGER.info("求取licenseKey入参：licenseKeyParam:{}", licenseKeyParam);

        Map<String, String> header = new HashMap<>();
        header.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, String.valueOf(DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.CAMEL_CASE_ROUTER_KEY)));
        String httpResp = HttpClientUtils.doRequest("GET", ModuleProperty.THEMEMAP_APP_LICENSEKEY + tenantId, header, null);

//        String httpResp = HttpClientUtils.doGet(ModuleProperty.THEMEMAP_APP_LICENSEKEY, param);
//        String httpResp = invokeOtherService(ModuleProperty.THEMEMAP_AP_NAME, ModuleProperty.THEMEMAP_MODULE_NAME, FieldNameConstant.LICENSEKEY_SERVICE_NAME,
//                FieldNameConstant.LICENSEKEY_METHOD_NAME, licenseKeyParam);

        if (StringUtils.isBlank(httpResp)) {
            return null;
        }
        JSONObject httpRespOjb = JSONObject.parseObject(httpResp);
        if (ModuleProperty.RESPONSE_SUCCESS_STATUS != httpRespOjb.getIntValue(FieldNameConstant.DW_SERVICE_STATUS)) {
            return null;
        }
        String data = httpRespOjb.getString(FieldNameConstant.DW_SERVICE_RESPONSE);
        return SecurityUtils.decodeAes(data);
    }

    /**
     * 获取ActionX的执行规则
     *
     * @param ruleId
     * @return
     */
    public static JSONObject getRuleInfo(String ruleId) {
        Map<String, String> header = new HashMap<>();
        header.put(FieldNameConstant.USER_TOKEN, DWServiceContext.getContext().getToken());
        header.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, String.valueOf(DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.CAMEL_CASE_ROUTER_KEY)));
        header.put(FieldNameConstant.SECURITY_TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SECURITY_TOKEN));

        String httpResp = HttpClientUtils.doRequest("GET", ModuleProperty.THEMEMAP_ACTION_RULE + ruleId, header, null);

        ///String httpResp = hahah();

        if (StringUtils.isBlank(httpResp)) {
            return null;
        }

        return Optional.of(httpResp)
                .map(resp -> JSONObject.parseObject(resp))
                .filter(obj -> ModuleProperty.RESPONSE_SUCCESS_STATUS == obj.getIntValue(FieldNameConstant.DW_SERVICE_STATUS))
                .map(obj -> obj.getJSONObject(FieldNameConstant.DW_SERVICE_RESPONSE))
                .orElse(null);
    }

    public static JSONObject getRuleInfoParaller(String ruleId,String token,String routerKey) {
        Map<String, String> header = new HashMap<>();
        header.put(FieldNameConstant.USER_TOKEN, token);
        header.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, routerKey);
        header.put(FieldNameConstant.SECURITY_TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SECURITY_TOKEN));

        String httpResp = HttpClientUtils.doRequest("GET", ModuleProperty.THEMEMAP_ACTION_RULE + ruleId, header, null);

        ///String httpResp = hahah();

        if (StringUtils.isBlank(httpResp)) {
            return null;
        }

        return Optional.of(httpResp)
                .map(resp -> JSONObject.parseObject(resp))
                .filter(obj -> ModuleProperty.RESPONSE_SUCCESS_STATUS == obj.getIntValue(FieldNameConstant.DW_SERVICE_STATUS))
                .map(obj -> obj.getJSONObject(FieldNameConstant.DW_SERVICE_RESPONSE))
                .orElse(null);
    }

    /*
    private static String hahah(){
        InputStream inputStream;
        String data = "";
        try {
            inputStream = new ClassPathResource("trans.json").getInputStream();
            byte[] buffer = new byte[inputStream.available()];
            int count = 0;
            while ((count = inputStream.read(buffer)) > 0) {
                data = new String(buffer, StandardCharsets.UTF_8);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return data;
    }
    */


    /**
     * 获取租户的token并添加到上下文中
     *
     * @param tenantId
     * @return
     * @throws Exception
     */
    public static String getTenantTokenAndAddProfile(String tenantId) throws Exception {
        String secretKey = getTenantSecretKey(tenantId);
        if (StringUtils.isBlank(secretKey)) {
            return "";
        }
        Map<String, Object> iamResult = getLoginResponse(secretKey);
        if (MapUtils.isEmpty(iamResult)) {
            return StringUtils.EMPTY;
        }
        Map<String, Object> profile = new HashMap<>();
        profile.put(FieldNameConstant.TENANT_ID, MapUtils.getString(iamResult, FieldNameConstant.TENANT_ID));
        profile.put(FieldNameConstant.TENANT_NAME, MapUtils.getString(iamResult, FieldNameConstant.TENANT_NAME));
        profile.put(FieldNameConstant.TENANT_SID, MapUtils.getLongValue(iamResult, FieldNameConstant.TENANT_SID));
        profile.put(FieldNameConstant.USER_ID, MapUtils.getString(iamResult, FieldNameConstant.USER_ID));
        profile.put(FieldNameConstant.USER_NAME, MapUtils.getString(iamResult, FieldNameConstant.USER_NAME));
        DWServiceContext.getContext().setToken(MapUtils.getString(iamResult, FieldNameConstant.USER_TOKEN));
        DWServiceContext.getContext().setProfile(profile);
        return MapUtils.getString(iamResult, FieldNameConstant.USER_TOKEN);

    }


    /**
     * 获取登录用户信息
     *
     * @return
     */
    public static Map<String, Object> getLoginResponse(String secretKey) throws Exception {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put(FieldNameConstant.SECRETKEY_KEY, secretKey);
        paramMap.put(FieldNameConstant.IDENTITY_TYPE_KEY, ModuleProperty.IAM_IDENTITYTYPE);

        ServiceModel iamModel = new ServiceModel();
        iamModel.setInvokeURL(ModuleProperty.IAM_USERLOGINURL);
        iamModel.setParams(paramMap);
        iamModel.setRequestMethod(DWRequestMethod.POST);
        HttpResponseModel responseModel = (HttpResponseModel) IAMService.invoke(iamModel);

        if (ModuleProperty.RESPONSE_SUCCESS_STATUS == responseModel.getHttpStatusCode()) {
            return JSONObject.parseObject(responseModel.getResponseBody());
        }
        return null;
    }


    public static ResponseModel callEsp(RequestModel requestModel) throws Exception {
        return InvokerProxy.invokeRestSync(requestModel);
    }

    @Deprecated
    public static String callEsp(EspSdkReqParam reqParam) throws Exception {
        Map<String, String> header = new HashMap<>();
        header.put(FieldNameConstant.USER_TOKEN, reqParam.getToken());
        header.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, String.valueOf(DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.CAMEL_CASE_ROUTER_KEY)));

        return InvokerProxy.invokeRestSync(reqParam.getHostProd(), reqParam.getHostVer(),
                reqParam.getHostId(), reqParam.getHostAcct(), reqParam.getTenantId(),
                reqParam.getServiceProd(), reqParam.getServiceProdUid(), reqParam.getServiceName(),
                reqParam.getDatakey(), header, reqParam.getBodyJsonString(), reqParam.getEocMap());
    }

    /**
     * 求取LicenseKey入参
     *
     * @param tenantId
     * @return
     */
    public static Map<String, Object> licenseKeyParam(String tenantId) {
        Map<String, Object> param = new HashMap<>();
        StringBuilder sb = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        String key = DigestUtils.md5Hex(sb.append(tenantId).append(ModuleProperty.THEMEMAP_LICENSEKEY_REQUEST_FROM).append(timestamp).append(ModuleProperty.THEMEMAP_LICENSEKEY_MD5_KEY).toString());
        param.put(FieldNameConstant.TENANT_ID, tenantId);
        param.put("requestFrom", ModuleProperty.THEMEMAP_LICENSEKEY_REQUEST_FROM);
        param.put("timestamp", timestamp);
        param.put("key", key);
        return param;
    }
}
