/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.client.impl.ThemeMapClient;
import com.digiwin.athena.executionengine.util.DateUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="BizParamAction")
public class BizParamAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(BizParamAction.class);
    private ThemeMapClient themeMapClient;

    @Resource
    public void setThemeMapClient(ThemeMapClient themeMapClient) {
        this.themeMapClient = themeMapClient;
    }

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        if (metaObj.containsKey((Object)"bizParamMeta") && !metaObj.getJSONObject("bizParamMeta").isEmpty()) {
            LOGGER.info("BizParamAction \u83b7\u53d6EE\u4e1a\u52a1\u53d8\u91cf\u7684bizParamMeta\u4e3a:{}", (Object)metaObj);
            JSONObject dataJson = new JSONObject();
            ArrayList<String> commonVarParamList = new ArrayList<String>();
            JSONObject bizParamMetas = metaObj.getJSONObject("bizParamMeta");
            String paramName = bizParamMetas.getString("paramName");
            String paramValue = bizParamMetas.getString("paramValue");
            String paramType = bizParamMetas.getString("paramType");
            if ("system".equals(paramType)) {
                switch (paramValue) {
                    case "s_runTime": {
                        paramValue = DateUtils.getCurrentDateTime("yyyy-MM-dd HH:mm:ss");
                        break;
                    }
                    case "s_runDate": {
                        paramValue = DateUtils.getCurrentDateTime("yyyy-MM-dd");
                        break;
                    }
                    case "s_userName": {
                        paramValue = (String)context.getInputParam().getSysParam().get("loginUserName");
                        break;
                    }
                    case "s_userId": {
                        paramValue = (String)context.getInputParam().getSysParam().get("userId");
                    }
                }
                dataJson.put(paramName, (Object)paramValue);
            } else {
                commonVarParamList.add(paramValue);
            }
            if (!commonVarParamList.isEmpty()) {
                LOGGER.info("BizParamAction EE\u9700\u8981\u8c03\u7528km\u83b7\u53d6\u4e1a\u52a1\u53d8\u91cf\u503c\uff1a{} \u4e3a\u83b7\u53d6\u5230\u8bbe\u5b9a\u503c", (Object)String.join((CharSequence)",", commonVarParamList));
                JSONObject respData = this.themeMapClient.querySmartDataVariable(context.getTenantId(), commonVarParamList, context.getToken());
                for (String commonVarParam : commonVarParamList) {
                    if (!respData.containsKey((Object)commonVarParam)) continue;
                    JSONObject commonVarParamJson = respData.getJSONObject(commonVarParam);
                    String status = commonVarParamJson.getString("status");
                    if ("1".equals(status)) {
                        dataJson.put(paramName, commonVarParamJson.get((Object)"value"));
                        continue;
                    }
                    LOGGER.info("BizParamAction EE\u83b7\u53d6\u4e1a\u52a1\u53d8\u91cf\uff1a{} \u672a\u542f\u7528\u6216\u8005\u672a\u8bbe\u5b9a\u503c", (Object)commonVarParam);
                }
            }
            return dataJson;
        }
        return null;
    }
}

