/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ICriteriaTransformer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.template.ITransSchemaCreator;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ReplaceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransDefinitionConvertor
implements ITransDefinitionConvertor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransDefinitionConvertor.class);
    private static final String SUFFIX = "Transformer";
    @Autowired
    private ITransSchemaCreator transSchemaCreator;

    @Override
    public JSONObject convert(JSONObject criteriaDefinition) {
        String technique = criteriaDefinition.getString("technique");
        JSONObject schema = criteriaDefinition.getJSONObject("schema");
        JSONObject variable = ContextUtils.getBean(technique + SUFFIX, ICriteriaTransformer.class).analysisVariable(schema);
        String template = this.transSchemaCreator.createTransSchemaByTechnique(technique);
        try {
            return JSONObject.parseObject((String)ReplaceUtils.replace(variable, template));
        }
        catch (Exception e) {
            LOGGER.error("micTrans\u5b9a\u4e49\u8f6c\u6362\u5931\u8d25,variable:{},template:{}", new Object[]{variable, template, e});
            throw e;
        }
    }
}

