/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans;

import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.ITransStep;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public abstract class TransAbstractStep
implements ITransStep {
    @Override
    public int dealData(Step step) {
        DealResult dataResult = this.doDealData(step);
        if (dataResult.getResult() != 0 && dataResult.getData() != null) {
            this.getTransDataManager().setCurrentData(step.getName(), dataResult.getData());
        }
        return dataResult.getResult();
    }

    protected Object getCurrentData(String name) {
        return this.getTransDataManager().getCurrentData(name);
    }

    protected TransDataManger getTransDataManager() {
        return TransEngine.getLocalContext();
    }

    protected Object getCurrentData(List<String> prevStepNameList) {
        if (CollectionUtils.isNotEmpty(prevStepNameList)) {
            return this.getTransDataManager().getCurrentData(prevStepNameList.get(0));
        }
        return this.getTransDataManager().getOriginData();
    }

    protected boolean isTableStructure(Object inputData) {
        if (!(inputData instanceof List)) {
            return false;
        }
        List dataList = (List)inputData;
        return !CollectionUtils.isNotEmpty((Collection)dataList) || dataList.get(0) instanceof Map;
    }

    protected Object getOriginData() {
        return this.getTransDataManager().getOriginData();
    }

    protected abstract DealResult doDealData(Step var1);

    @Override
    public abstract boolean defineCheck(StepElement var1);
}

