/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.RuntimeInfoElement;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="getRuntimeInfo")
public class GetRuntimeInfoStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRuntimeInfoStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        List<RuntimeInfoElement> rules = stepElement.getRuntimeInfoStepRule();
        for (RuntimeInfoElement rule : rules) {
            String infoType = rule.getInfoType();
            if ("currentTime".equals(infoType)) {
                if (this.checkCurrentTime(rule)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean checkCurrentTime(RuntimeInfoElement rule) {
        if (StringUtils.isEmpty((CharSequence)rule.getFormat()) || StringUtils.isEmpty((CharSequence)rule.getMethod()) || StringUtils.isEmpty((CharSequence)rule.getNewField())) {
            return false;
        }
        return "dynamic".equals(rule.getMethod()) || "static".equals(rule.getMethod());
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        Object inputData = this.getCurrentData(step.getPrevStepNameList());
        if (!(inputData instanceof List)) {
            LOGGER.warn("\u83b7\u53d6\u7cfb\u7edf\u53d8\u91cf\u7ec4\u4ef6\u53ea\u80fd\u63a5\u53d7\u8868\u72b6\u6570\u636e\uff0c\u975e\u5c55\u5e73\u6570\u636e\u9700\u8981\u5148\u6267\u884c\u5c55\u5e73\u8282\u70b9\uff01Trans\u6267\u884c {} \u5931\u8d25\uff0c\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01", (Object)step.getName());
            dealResult.setDataNullFail();
            return dealResult;
        }
        List dataList = (List)inputData;
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            dealResult.setSuccess(Lists.newArrayList());
            return dealResult;
        }
        List<RuntimeInfoElement> rules = step.getStepElement().getRuntimeInfoStepRule();
        for (Map data : dataList) {
            if (this.getRuntimeInfo(rules, data)) continue;
            dealResult.setData(null);
            dealResult.setResult(0);
            return dealResult;
        }
        dealResult.setSuccess(dataList);
        return dealResult;
    }

    private boolean getRuntimeInfo(List<RuntimeInfoElement> rules, Map<String, Object> data) {
        for (RuntimeInfoElement rule : rules) {
            String infoType = rule.getInfoType();
            String method = rule.getMethod();
            if ("currentTime".equals(infoType)) {
                this.setCurrentTime(data, rule, method);
                continue;
            }
            return false;
        }
        return true;
    }

    private void setCurrentTime(Map<String, Object> data, RuntimeInfoElement rule, String method) {
        String currentTime = DateUtils.getCurrentDateTime();
        if ("static".equals(method)) {
            data.put(rule.getNewField(), DateUtils.transferFormat(currentTime, rule.getFormat()));
        } else {
            data.put(rule.getNewField(), DateUtils.getCurrentDateTime(rule.getFormat()));
        }
    }
}

