/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.mapping.test;

import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingHandler;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.digiwin.athena.executionengine.service.facade.mapping.test.CaseModule;

public class DataMappingTestUtil {
    public ExecuteContext context;
    public DataMappingManager dataMappingManager;
    public CaseModule testCase;

    public DataMappingTestUtil(CaseModule testCase, ExecuteContext context, DataMappingManager dataMappingManager) {
        this.testCase = testCase;
        this.context = context;
        context.addActionResponse(testCase.rspActionId, testCase.response, testCase.isForeach, "");
        this.dataMappingManager = dataMappingManager;
    }

    private void checkRes(Object res) {
        if (this.testCase.testRes != null) {
            String oStr = this.testCase.caseName;
            oStr = this.testCase.testRes.equals(res) ? oStr + "  ----> [OK]" : oStr + "  ----> [Failed] \n Expect: " + this.testCase.testRes + "\n Result: " + res;
            System.out.println(oStr);
        }
    }

    public void runGetDataMappingHandler() {
        DataMappingHandler handler = this.dataMappingManager.getDatMappingHandler(this.testCase.reqActionId, this.testCase.rspActionId);
    }

    public void runGetJsonByParamPath() {
        DataMappingHandler handler = this.dataMappingManager.getDatMappingHandler(this.testCase.reqActionId, this.testCase.rspActionId);
        this.checkRes(handler.getConcreteJson(this.testCase.paramPath));
    }

    public void runGetZoneDataSize() {
        DataMappingHandler handler = this.dataMappingManager.getDatMappingHandler(this.testCase.reqActionId, this.testCase.rspActionId);
        this.checkRes(handler.getZoneDataSize(this.testCase.paramPath));
    }

    public void runGetZoneDataSizeByJpath() {
        DataMappingHandler handler = this.dataMappingManager.getDatMappingHandler(this.testCase.reqActionId, this.testCase.rspActionId);
        this.checkRes(handler.getZoneDataSize(this.testCase.paramPath, this.testCase.fixedPath));
    }

    public void runGetPathDataSize() {
        DataMappingHandler handler = this.dataMappingManager.getDatMappingHandler(this.testCase.reqActionId, this.testCase.rspActionId);
        this.checkRes(handler.getPathDataSize(this.testCase.paramPath, this.testCase.fixedPath));
    }

    public void runCountCollectionInPath() {
        DataMappingHandler handler = this.dataMappingManager.getDatMappingHandler(this.testCase.reqActionId, this.testCase.rspActionId);
        this.checkRes(handler.countCollectionInPath(this.testCase.paramPath));
    }

    public void runGetCollectionParamPathList() {
        DataMappingHandler handler = this.dataMappingManager.getDatMappingHandler(this.testCase.reqActionId, this.testCase.rspActionId);
        this.checkRes(handler.getCollectionParamPathList(this.testCase.paramPath));
    }

    public void runNext(int times) {
        DataMappingHandler handler = this.dataMappingManager.getDatMappingHandler(this.testCase.reqActionId, this.testCase.rspActionId);
        System.out.println("\u6b65\u8fdb\u6267\u884c\u524d\uff1aJsonPath: " + handler.getConcreteJson(this.testCase.paramPath));
        for (int i = 0; i < times; ++i) {
            handler.next(this.testCase.paramPath, null);
            System.out.println("\u7b2c" + String.valueOf(i + 1) + "\u6b65\uff1aJsonPath: " + handler.getConcreteJson(this.testCase.paramPath));
        }
    }
}

