/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.enumtype.ValueTypeEnum;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.util.CloneUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="input")
public class InputStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        String nullDefaultConstruct = stepElement.getNullDefaultConstruct();
        String jsonPath = stepElement.getPath();
        if (StringUtils.isEmpty((CharSequence)jsonPath)) {
            LOGGER.error("input,rule\u5b9a\u4e49path\u8282\u70b9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)nullDefaultConstruct)) {
            return nullDefaultConstruct.equalsIgnoreCase(ValueTypeEnum.ARRAY.getType()) || nullDefaultConstruct.equalsIgnoreCase(ValueTypeEnum.OBJECT.getType());
        }
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        try {
            Object originData = this.getOriginData();
            if (!(originData instanceof Map)) {
                LOGGER.error("\u5165\u53c2\u8bfb\u53d6\u7ec4\u4ef6\u9700\u8981\u8f93\u5165\u7684\u662f\u4e00\u4e2aMap\u7ed3\u6784\uff01\u4f46\u662f\u5f53\u524d\u662f\uff1a{}", (Object)originData.getClass().getSimpleName());
                dealResult.setDataNullFail();
                return dealResult;
            }
            StepElement stepElement = step.getStepElement();
            String jsonPath = stepElement.getPath();
            Object originDataPart = this.getJsonPathVal(originData, jsonPath);
            if (originDataPart == null) {
                dealResult.setSuccess(this.getDefaultData(stepElement));
                return dealResult;
            }
            Object newData = CloneUtil.clone(originDataPart);
            dealResult.setSuccess(newData);
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("\u5165\u53c2\u8bfb\u53d6\u7ec4\u4ef6\u51fa\u73b0\u5f02\u5e38");
            throw e;
        }
    }

    private Object getJsonPathVal(Object obj, String path) {
        if (null == obj || StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        Configuration conf = Configuration.defaultConfiguration();
        try {
            Configuration readConf = conf.addOptions(new Option[]{Option.REQUIRE_PROPERTIES});
            DocumentContext ctx = JsonPath.using((Configuration)readConf).parse(JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            return ctx.read(path, new Predicate[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790json:{}\u4e2d\u7684\u8def\u5f84{}\u5f02\u5e38:{}", new Object[]{obj, path, e});
            return null;
        }
    }

    private Object getDefaultData(StepElement stepElement) {
        String jsonPath;
        String nullDefaultConstruct = stepElement.getNullDefaultConstruct();
        if (nullDefaultConstruct != null) {
            if (nullDefaultConstruct.equalsIgnoreCase(ValueTypeEnum.ARRAY.getType())) {
                return Lists.newArrayList();
            }
            if (nullDefaultConstruct.equalsIgnoreCase(ValueTypeEnum.OBJECT.getType())) {
                return Maps.newHashMap();
            }
        }
        if ((jsonPath = stepElement.getPath()).indexOf("[*]") != -1) {
            return Lists.newArrayList();
        }
        return Maps.newHashMap();
    }
}

