/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.service.srp.ITransSrp;
import com.digiwin.athena.executionengine.util.ContextUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="TransAction")
public class TransAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransAction.class);

    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        String ruleId = actionParam.getMetaObj().getString("ruleId");
        try {
            ServiceResult serviceResult = ContextUtils.getBean(ITransSrp.class, new Object[0]).runTransByTransAction(context, ruleId, reqMap);
            context.setExecuteStatus(serviceResult.getSuccess());
            return serviceResult.getData();
        }
        catch (Exception e) {
            context.setExecuteStatus(false);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0007");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.X);
            context.setExecuteErrorMessage(executeErrorMessage);
            LOGGER.error("\u6267\u884c\u5f15\u8c03\u7528trans\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }
}

