/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.core.container;

import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.core.container.RunInfo;
import com.digiwin.athena.executionengine.core.holder.ReadContextHolder;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.service.facade.execution.asyc.ActionQueue;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ExecuteContext {
    Map<String, ActionParam> actionParamMap;
    Map<String, Object> actionResponseMap;
    Map<String, String> line = new HashMap<String, String>();
    Map<String, ParamElement> paramElementMap;
    InputParamModule inputParam;
    Set<String> inputParamKeys;
    Set<String> sysParamKeys;
    String token;
    String securityToken;
    String BMDtoken;
    private boolean executeStatus;
    private String currentActionId;
    private DataMappingManager dataMappingManager;
    private String locale;
    private RunInfo runInfo;
    private ReadContextHolder readContextHolder;
    private Map<String, Object> mockData;
    private ExecuteErrorMessage executeErrorMessage;
    public ActionQueue actionQueue = new ActionQueue();
    public int pullLevel;
    private boolean isRelease = true;
    private String routerKey;
    private String monitorProcessType;
    private long messageId;
    private String application;
    private String taskType;
    private String taskCode;
    private ErrorLog errorLog;
    private String rootMetricId;
    private Map<String, List<String>> querySqlMap = new HashMap<String, List<String>>();
    private boolean isDebug = false;

    public Map<String, String> getLine() {
        return this.line;
    }

    public ExecuteErrorMessage getExecuteErrorMessage() {
        return this.executeErrorMessage;
    }

    public void setExecuteErrorMessage(ExecuteErrorMessage executeErrorMessage) {
        this.executeErrorMessage = executeErrorMessage;
    }

    public Map<String, Object> getMockData() {
        return this.mockData;
    }

    public ActionQueue getActionQueue() {
        return this.actionQueue;
    }

    public boolean isRelease() {
        return this.isRelease;
    }

    public void setRelease(boolean release) {
        this.isRelease = release;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public String getMonitorProcessType() {
        return this.monitorProcessType;
    }

    public void setMonitorProcessType(String monitorProcessType) {
        this.monitorProcessType = monitorProcessType;
    }

    public String getRouterKey() {
        return this.routerKey;
    }

    public void setRouterKey(String routerKey) {
        this.routerKey = routerKey;
    }

    public ErrorLog getErrorLog() {
        return this.errorLog;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this.errorLog = errorLog;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean debug) {
        this.isDebug = debug;
    }

    public String getRootMetricId() {
        return this.rootMetricId;
    }

    public void setRootMetricId(String rootMetricId) {
        this.rootMetricId = rootMetricId;
    }

    public Map<String, List<String>> getQuerySqlMap() {
        return this.querySqlMap;
    }

    public void setQuerySqlMap(Map<String, List<String>> querySqlMap) {
        this.querySqlMap = querySqlMap;
    }

    public ExecuteContext() {
        this.actionParamMap = new HashMap<String, ActionParam>();
        this.actionResponseMap = new ConcurrentHashMap<String, Object>();
        this.paramElementMap = new HashMap<String, ParamElement>();
        this.inputParam = new InputParamModule();
        this.inputParamKeys = new HashSet<String>();
        this.sysParamKeys = new HashSet<String>();
        this.executeStatus = true;
        this.dataMappingManager = new DataMappingManager(this.actionResponseMap, this.inputParam);
        this.runInfo = new RunInfo();
        this.readContextHolder = new ReadContextHolder();
        this.dataMappingManager.setReadContextHolder(this.readContextHolder);
        this.pullLevel = 0;
    }

    public ExecuteContext(InputParamModule inputParam, String token) {
        this.actionParamMap = new HashMap<String, ActionParam>();
        this.actionResponseMap = new ConcurrentHashMap<String, Object>();
        this.paramElementMap = new HashMap<String, ParamElement>();
        this.inputParam = inputParam;
        this.token = token;
        this.inputParamKeys = new HashSet<String>();
        this.sysParamKeys = new HashSet<String>();
        this.executeStatus = true;
        this.dataMappingManager = new DataMappingManager(this.actionResponseMap, inputParam);
        this.runInfo = new RunInfo();
        this.readContextHolder = new ReadContextHolder();
        this.mockData = inputParam.getMockData();
        this.dataMappingManager.setReadContextHolder(this.readContextHolder);
    }

    public DataMappingManager getDataMappingManager() {
        return this.dataMappingManager;
    }

    public void addActionParam(ActionParam actionParam) {
        this.actionParamMap.put(actionParam.getActionId(), actionParam);
    }

    public ActionParam getActionParam(String actionId) {
        return this.actionParamMap.get(actionId);
    }

    public void addActionResponse(String actionId, Object resp, boolean isForeach, String actionType) {
        if (resp == null) {
            return;
        }
        if (resp instanceof List && (ActionTypeEnum.BMD_GENERAL_ACTION.getType().equals(actionType) || ActionTypeEnum.BMD_ACTION.getType().equals(actionType) || ActionTypeEnum.MICRO_TRANS_ACTION.getType().equalsIgnoreCase(actionType) || ActionTypeEnum.SQL_ACTION.getType().equalsIgnoreCase(actionType))) {
            if (!this.containsActionResp(actionId)) {
                HashMap<String, Object> executeRes = new HashMap<String, Object>();
                executeRes.put("data", resp);
                this.actionResponseMap.put(actionId, executeRes);
            } else {
                Map res = (Map)this.actionResponseMap.get(actionId);
                List resultList = (List)res.get("data");
                resultList.addAll((List)resp);
            }
            return;
        }
        if (!isForeach) {
            this.actionResponseMap.put(actionId, resp);
        } else {
            this.actionResponseMap.computeIfAbsent(actionId, k -> Lists.newArrayList());
            List resultList = (List)this.actionResponseMap.get(actionId);
            resultList.add(resp);
        }
    }

    public void removeActionResponse(String actionId) {
        this.actionResponseMap.remove(actionId);
    }

    public Object getActionResponse(String actionId) {
        return this.actionResponseMap.get(actionId);
    }

    public Map<String, Object> getActionResponse() {
        return this.actionResponseMap;
    }

    public boolean containsActionResp(String actionId) {
        return this.actionResponseMap.containsKey(actionId);
    }

    public void addParamElement(String paramPath, ParamElement element) {
        this.paramElementMap.put(paramPath, element);
    }

    public void clearParamElement() {
        this.paramElementMap.clear();
    }

    public void reSetInputParas(List<Map<String, Object>> paras) {
        this.inputParam.setParas(paras);
    }

    public ParamElement getParamElement(String paramPath) {
        return this.paramElementMap.get(paramPath);
    }

    public boolean isNotExistParamElement(String paramPath) {
        return this.paramElementMap.get(paramPath) != null;
    }

    public InputParamModule getInputParam() {
        return this.inputParam;
    }

    public String getTenantId() {
        return this.inputParam.getTenantId();
    }

    public List<Map<String, Object>> getInputParas() {
        return this.inputParam.getParas();
    }

    public Set<String> getInputParamKeys() {
        return this.inputParamKeys;
    }

    public void addInputParamKey(String key) {
        this.inputParamKeys.add(key);
    }

    public void addInputParamKey(String key, String inputParamPart) {
        if ("ExecutionParam".equals(inputParamPart)) {
            this.inputParamKeys.add(key);
        } else if ("ExecutionSysParam".equals(inputParamPart)) {
            this.sysParamKeys.add(key);
        }
    }

    public Set<String> getSysParamKeys() {
        return this.sysParamKeys;
    }

    public void addSysParamKey(String key) {
        this.sysParamKeys.add(key);
    }

    public boolean isExecuteStatus() {
        return this.executeStatus;
    }

    public void setExecuteStatus(boolean executeStatus) {
        this.executeStatus = executeStatus;
    }

    public String getCurrentActionId() {
        return this.currentActionId;
    }

    public void setCurrentActionId(String currentActionId) {
        this.currentActionId = currentActionId;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, Object> getEocMap() {
        return this.inputParam.getEocMap();
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public RunInfo getRunInfo() {
        return this.runInfo;
    }

    public void addActionRuninfo(String actionId, int code, String message) {
    }

    public Map<String, ActionParam> getActionParamMap() {
        return this.actionParamMap;
    }

    public ReadContextHolder getParamGetDataHandler() {
        return this.readContextHolder;
    }

    public void setBMDtoken(String BMDtoken) {
        this.BMDtoken = BMDtoken;
    }

    public String getBMDtoken() {
        return this.BMDtoken;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getTaskCode() {
        return this.taskCode;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }
}

