/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.BaseObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DatasetObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Filter;
import com.digiwin.athena.executionengine.model.input.SolutinStep.FilterHavingChildren;
import com.digiwin.athena.executionengine.model.input.SolutinStep.FilterHavingChildrenRight;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.service.facade.analyzer.IDataValueExtractor;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.analyzer.impl.DatasetObjectSolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="filterStep")
public class FilterSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterSolutionStepAnalyzer.class);
    @Autowired
    private IDataValueExtractor dataValueExtractor;
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object filterData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("filterStep\u5f00\u59cb\u6267\u884cfilter==null:{}", (Object)(filterData == null ? "true" : "false"));
        if (filterData != null) {
            JSONObject criteriaDefinition = new JSONObject();
            criteriaDefinition.put("technique", (Object)"filter");
            Filter newFilter = new Filter();
            Filter filter = solutionStep.getFilter();
            newFilter.setLogic(filter.getLogic());
            JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)filterData));
            if (CollectionUtils.isEmpty((Collection)dataArray)) {
                return;
            }
            JSONObject data = dataArray.getJSONObject(0);
            Set dataFieldKeys = data.keySet();
            List selectedFieldKeys = solutionStep.getSelect().stream().filter(select -> select.getDataObject() != null).map(select -> select.getDataObject().getContent()).collect(Collectors.toList());
            HashSet<String> fieldKeys = new HashSet<String>(selectedFieldKeys);
            List<FilterHavingChildren> newChildren = this.dealChildren(filter.getChildren(), solutionStep.getComputeList(), fieldKeys, dataFieldKeys, context, dataKey, stepIndex, solutionStep.getDatasetObject().getAlias(), data);
            if (CollectionUtils.isNotEmpty(newChildren)) {
                newFilter.setChildren(newChildren);
                criteriaDefinition.put("schema", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)newFilter)));
                JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
                LOGGER.info("filterStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                Object object = filterData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
                if (filterData != null) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put(dataKey, filterData);
                    TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                    TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
                    Object resultData = transEngine.runEngine(transDataManger);
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                    LogUtils.buildAgileLog("filterData", LogUtils.SUCCESS, String.format("filterData\u8fc7\u6ee4\u524d\u6570\u636e\u6761\u76ee\u6570:%s,\u8fc7\u6ee4\u6761\u4ef6:%s", JSONArray.parseArray((String)JSONObject.toJSONString((Object)filterData)).size(), JSONObject.toJSONString((Object)newFilter)), String.format("filterData\u8fc7\u6ee4\u540e\u6570\u636e\u6761\u76ee\u6570:%s", resultData == null ? "null" : Integer.valueOf(JSONArray.parseArray((String)JSONObject.toJSONString((Object)resultData)).size())), "");
                }
            }
            ISolutionStepAnalyzer selectStep = (ISolutionStepAnalyzer)ContextUtils.getBean("selectStep", new Object[0]);
            selectStep.executeStep(solutionStep, stepIndex, context);
        }
    }

    private List<FilterHavingChildren> dealChildren(List<FilterHavingChildren> children, JSONObject computeList, Set<String> fieldKeys, Set<String> dataFieldKeys, SolutionStepContext context, String dataKey, int stepIndex, String alias, JSONObject data) {
        ArrayList<FilterHavingChildren> newChildren = new ArrayList<FilterHavingChildren>();
        if (CollectionUtils.isEmpty(children)) {
            return newChildren;
        }
        for (FilterHavingChildren filterHavingChildren : children) {
            List<FilterHavingChildren> childChildren;
            FilterHavingChildren newChild = new FilterHavingChildren();
            newChild.setOperator(filterHavingChildren.getOperator());
            newChild.setLogic(filterHavingChildren.getLogic());
            BaseObject leftObject = this.createCalculateBaseObject(filterHavingChildren.getLeft(), filterHavingChildren.getLeft(), computeList, fieldKeys, dataFieldKeys, context, dataKey, data);
            if (leftObject != null) {
                newChild.setLeft(leftObject);
            }
            ArrayList<FilterHavingChildrenRight> newRightList = new ArrayList<FilterHavingChildrenRight>();
            List<FilterHavingChildrenRight> rightList = filterHavingChildren.getRight();
            if (CollectionUtils.isNotEmpty(rightList)) {
                for (FilterHavingChildrenRight filterHavingChildrenRight : rightList) {
                    FilterHavingChildrenRight newChildRight = new FilterHavingChildrenRight();
                    if (filterHavingChildrenRight.getDataObject() != null) {
                        BaseObject rightObject = this.createCalculateBaseObject(filterHavingChildrenRight.getDataObject(), filterHavingChildren.getLeft(), computeList, fieldKeys, dataFieldKeys, context, dataKey, data);
                        if (rightObject != null) {
                            newChildRight.setDataObject(rightObject);
                            continue;
                        }
                        newChildRight = null;
                        continue;
                    }
                    DatasetObject datasetObject = filterHavingChildrenRight.getDatasetObject();
                    Object rightData = null;
                    if ("metric".equals(datasetObject.getDatasetType())) {
                        rightData = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                    } else if ("step".equals(datasetObject.getDatasetType())) {
                        Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                        if (dataMap.containsKey(datasetObject.getStep())) {
                            rightData = dataMap.get(datasetObject.getStep());
                            rightData = this.dataValueExtractor.extract(datasetObject.getContent(), filterHavingChildren.getOperator(), rightData);
                        }
                    } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                        DatasetObjectSolutionStepAnalyzer datasetObjectSolutionStepAnalyzer = (DatasetObjectSolutionStepAnalyzer)ContextUtils.getBean("datasetObjectStep", new Object[0]);
                        datasetObjectSolutionStepAnalyzer.executeStep(datasetObject.getSubQuery(), stepIndex, context);
                        Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                        String key = stepIndex + "-" + datasetObject.getSubQuery().getAlias();
                        if (dataMap.containsKey(key)) {
                            rightData = dataMap.get(key);
                        }
                    }
                    if ("in".equals(filterHavingChildren.getOperator()) || "nin".equals(filterHavingChildren.getOperator())) {
                        String[] split;
                        String rightStr = (String)rightData;
                        if (!StringUtils.isNotEmpty((CharSequence)rightStr)) continue;
                        for (String s : split = rightStr.split(",")) {
                            FilterHavingChildrenRight inChildRight = new FilterHavingChildrenRight();
                            BaseObject newBaseObject = new BaseObject();
                            newBaseObject.setContentType("const");
                            newBaseObject.setDataType("string");
                            newBaseObject.setContent(s);
                            inChildRight.setDataObject(newBaseObject);
                            newRightList.add(inChildRight);
                        }
                        continue;
                    }
                    BaseObject newBaseObject = new BaseObject();
                    newBaseObject.setContentType("const");
                    newBaseObject.setDataType("string");
                    newBaseObject.setContent((String)rightData);
                    newChildRight.setDataObject(newBaseObject);
                    newRightList.add(newChildRight);
                }
            }
            if (CollectionUtils.isNotEmpty(newRightList)) {
                newChild.setRight(newRightList);
            }
            if (CollectionUtils.isNotEmpty(childChildren = this.dealChildren(filterHavingChildren.getChildren(), computeList, fieldKeys, dataFieldKeys, context, dataKey, stepIndex, alias, data))) {
                newChild.setChildren(childChildren);
            }
            if (newChild.getLeft() == null || !CollectionUtils.isNotEmpty(newChild.getRight())) continue;
            newChildren.add(newChild);
        }
        return newChildren;
    }

    private BaseObject createCalculateBaseObject(BaseObject baseObject, BaseObject leftBaseObject, JSONObject computeList, Set<String> fieldKeys, Set<String> dataFieldKeys, SolutionStepContext context, String dataKey, JSONObject data) {
        if (baseObject == null || "datetime".equals(baseObject.getDataType()) || "datetime".equals(leftBaseObject.getDataType())) {
            return null;
        }
        BaseObject newBaseObject = new BaseObject();
        if ("calculate".equals(baseObject.getContentType())) {
            newBaseObject = this.doCalculate(baseObject, computeList, dataFieldKeys, context, dataKey);
            return newBaseObject;
        }
        if ("const".equals(baseObject.getContentType())) {
            if (!fieldKeys.contains(leftBaseObject.getContent())) {
                if (dataFieldKeys.contains(leftBaseObject.getContent())) {
                    for (String fieldKey : fieldKeys) {
                        JSONArray computeArray = computeList == null ? null : computeList.getJSONArray(fieldKey);
                        if (computeArray == null || !computeArray.toString().contains("\"content\":\"" + leftBaseObject.getContent() + "\"")) continue;
                        BeanUtils.copyProperties((Object)baseObject, (Object)newBaseObject);
                        return newBaseObject;
                    }
                    String dataInfo = data.getString(leftBaseObject.getContent());
                    if (!"default".equals(dataInfo)) {
                        BeanUtils.copyProperties((Object)baseObject, (Object)newBaseObject);
                        return newBaseObject;
                    }
                }
                return null;
            }
            if ("datetime".equals(baseObject.getDataType()) || "datetime".equals(leftBaseObject.getDataType())) {
                BeanUtils.copyProperties((Object)baseObject, (Object)newBaseObject);
                newBaseObject.setDataType("date");
                return newBaseObject;
            }
        }
        BeanUtils.copyProperties((Object)baseObject, (Object)newBaseObject);
        return newBaseObject;
    }

    private BaseObject doCalculate(BaseObject baseObject, JSONObject computeList, Set<String> dataFieldKeys, SolutionStepContext context, String dataKey) {
        BaseObject newObject = new BaseObject();
        if (!"calculate".equals(baseObject.getContentType())) {
            return baseObject;
        }
        String computeName = baseObject.getContent();
        JSONArray newComputeJsonArray = new JSONArray();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeJsonArray.size(); ++i) {
            JSONObject compute = computeJsonArray.getJSONObject(i);
            JSONArray parameters = compute.getJSONArray("params");
            boolean flag = false;
            for (int j = 0; j < parameters.size(); ++j) {
                JSONObject parameter = parameters.getJSONObject(j);
                if (dataFieldKeys.contains(parameter.getString("content")) || !"field".equals(parameter.getString("contentType"))) continue;
                flag = true;
                LOGGER.info("filterStep\u6267\u884cdoCalculate.trans\u4e2d\u8ba1\u7b97\u5217\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u96c6\u4e2d:{}", (Object)parameter.toJSONString());
            }
            if (flag) continue;
            newComputeJsonArray.add((Object)compute);
        }
        JSONObject schema = new JSONObject();
        schema.put("rule", (Object)newComputeJsonArray);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"calculate");
        criteriaDefinition.put("schema", (Object)schema);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("filterStep\u6267\u884cdoCalculate.trans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, SolutionStepExecutionFacade.getTransDataMap().get(dataKey), context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
        Object calculateResult = transEngine.runEngine(transDataManger);
        if (calculateResult == null) {
            LOGGER.info("filterStep\u6267\u884cdoCalculate.trans\u51fa\u53c2\u4e3anull");
            return baseObject;
        }
        JSONObject lastCalculateFunction = computeJsonArray.getJSONObject(computeJsonArray.size() - 1);
        newObject.setContent(lastCalculateFunction.getString("newField"));
        newObject.setSource(baseObject.getSource());
        newObject.setContentType("field");
        newObject.setDataType(lastCalculateFunction.getString("valueType"));
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
        return newObject;
    }
}

