/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.BaseObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DataObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DatasetObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Filter;
import com.digiwin.athena.executionengine.model.input.SolutinStep.FilterHavingChildren;
import com.digiwin.athena.executionengine.model.input.SolutinStep.FilterHavingChildrenRight;
import com.digiwin.athena.executionengine.model.input.SolutinStep.GroupBy;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Having;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Select;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Sort;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.analyzer.impl.DatasetObjectSolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="selectStep")
public class SelectSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectSolutionStepAnalyzer.class);
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object selectData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("selectStep\u5f00\u59cb\u6267\u884cselectData==null:{}", (Object)(selectData == null ? "true" : "false"));
        if (selectData != null) {
            HashMap<String, Object> dataMap;
            List<Select> selectList = solutionStep.getSelect();
            ArrayList computeSelectList = new ArrayList();
            ArrayList specialComputeSelectList = new ArrayList();
            selectList.forEach(select -> {
                if ("calculate".equals(select.getDataObject().getContentType())) {
                    String computeName = select.getDataObject().getContent();
                    JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
                    for (int j = 0; j < computeArray.size(); ++j) {
                        List methodList;
                        String computeType = computeArray.getJSONObject(j).getString("calFunction");
                        if ("RowNumber".equalsIgnoreCase(computeType) && !specialComputeSelectList.contains(select)) {
                            specialComputeSelectList.add(select);
                        }
                        if (!(methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList())).contains(computeType.toUpperCase()) || computeSelectList.contains(select)) continue;
                        computeSelectList.add(select);
                    }
                }
            });
            if (!specialComputeSelectList.isEmpty()) {
                for (Object select2 : specialComputeSelectList) {
                    JSONArray rowNumberGroupFields = new JSONArray();
                    String computeName = ((Select)select2).getDataObject().getContent();
                    JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
                    JSONArray oderByJson = computeArray.getJSONObject(0).getJSONObject("overParams").getJSONArray("orderBy");
                    JSONArray partitionArray = computeArray.getJSONObject(0).getJSONObject("overParams").getJSONArray("partition");
                    if (partitionArray != null) {
                        for (int j = 0; j < partitionArray.size(); ++j) {
                            JSONObject partition = partitionArray.getJSONObject(j);
                            String content = partition.getString("content");
                            if ("field".equalsIgnoreCase(partition.getString("contentType"))) {
                                rowNumberGroupFields.add((Object)content);
                                DataObject dataObject = (DataObject)JSON.parseObject((String)partition.toJSONString(), DataObject.class);
                                Sort sort = new Sort();
                                sort.setDataObject(dataObject);
                                sort.setOrder("asc");
                                oderByJson.add((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sort)));
                                continue;
                            }
                            Object tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                            JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)tempData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                            if (dataArray.isEmpty()) continue;
                            JSONObject data = dataArray.getJSONObject(0);
                            Set fieldKeys = data.keySet();
                            String newField = this.doRowNumberCalculate(content, solutionStep.getComputeList(), fieldKeys, selectData, context, dataKey);
                            rowNumberGroupFields.add((Object)newField);
                            DataObject dataObject = (DataObject)JSON.parseObject((String)partition.toJSONString(), DataObject.class);
                            dataObject.setContent(newField);
                            dataObject.setContentType("field");
                            Sort sort = new Sort();
                            sort.setDataObject(dataObject);
                            sort.setOrder("asc");
                            oderByJson.add((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sort)));
                        }
                    }
                    JSONObject sortJSON = new JSONObject();
                    sortJSON.put("fields", (Object)rowNumberGroupFields);
                    sortJSON.put("sort", (Object)oderByJson);
                    sortJSON.put("mode", (Object)"custom");
                    sortJSON.put("sortName", (Object)computeArray.getJSONObject(0).getString("newField"));
                    JSONObject criteriaDefinition = new JSONObject();
                    criteriaDefinition.put("technique", (Object)"sorts");
                    criteriaDefinition.put("schema", (Object)sortJSON);
                    JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
                    HashMap<String, Object> dataMap2 = new HashMap<String, Object>();
                    dataMap2.put(dataKey, SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
                    TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap2, context.getTenantId(), context.getEocMap(), context.getToken());
                    TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
                    Object resultData = transEngine.runEngine(transDataManger);
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                }
            }
            if (!CollectionUtils.isNotEmpty(solutionStep.getGroupby())) {
                JSONArray newDataArray = new JSONArray();
                if (!computeSelectList.isEmpty()) {
                    for (Select select3 : computeSelectList) {
                        selectData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                        this.doSelectCalculate(select3, solutionStep.getComputeList(), selectData, context, dataKey);
                    }
                }
                JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)SolutionStepExecutionFacade.getTransDataMap().get(dataKey), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject newJsonObject = new JSONObject();
                    JSONObject data = dataArray.getJSONObject(i);
                    Set keys = data.keySet();
                    for (String key : keys) {
                        if (!selectList.stream().anyMatch(select -> key.equals(select.getDataObject().getContent()))) continue;
                        newJsonObject.put(key, data.get((Object)key));
                    }
                    selectList.forEach(select -> {
                        if ("const".equals(select.getDataObject().getContentType())) {
                            DataObject dataObject = select.getDataObject();
                            newJsonObject.put(dataObject.getAlias(), (Object)dataObject.getContent());
                        }
                    });
                    if (newJsonObject.isEmpty()) continue;
                    newDataArray.add((Object)newJsonObject);
                }
                SolutionStepExecutionFacade.getTransDataMap().put(dataKey, newDataArray);
                if (newDataArray.isEmpty() && !dataArray.isEmpty()) {
                    List<String> selectFunctionName = selectList.stream().filter(select -> "calculate".equals(select.getDataObject().getContentType())).map(select -> select.getDataObject().getContent()).collect(Collectors.toList());
                    JSONObject computeList = solutionStep.getComputeList();
                    JSONArray functionFields = this.createFunctionFields(selectFunctionName, computeList);
                    dataMap = new HashMap<String, Object>();
                    dataMap.put(dataKey, selectData);
                    Object result = this.doGroupTrans(new JSONArray(), functionFields, dataMap, context);
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, result);
                }
            } else {
                JSONArray groupFields = new JSONArray();
                Iterator<Select> tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)tempData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                if (!dataArray.isEmpty()) {
                    JSONObject data = dataArray.getJSONObject(0);
                    Object fieldKeys = data.keySet();
                    for (GroupBy groupBy : solutionStep.getGroupby()) {
                        if ("field".equals(groupBy.getContentType())) {
                            groupFields.add((Object)groupBy.getContent());
                            continue;
                        }
                        if (!"calculate".equals(groupBy.getContentType())) continue;
                        tempData = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                        GroupBy newGroupBy = this.doGroupCalculate(groupBy, solutionStep.getComputeList(), (Set<String>)fieldKeys, tempData, context, dataKey);
                        if (groupFields.contains((Object)newGroupBy.getContent())) continue;
                        groupFields.add((Object)newGroupBy.getContent());
                    }
                    dataMap = new HashMap();
                    dataMap.put(dataKey, SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
                    JSONObject computeList = solutionStep.getComputeList();
                    Set computeKeys = computeList.keySet();
                    JSONArray functionFields = this.createFunctionFields(new ArrayList<String>(computeKeys), computeList);
                    Object resultData = this.doGroupTrans(groupFields, functionFields, dataMap, context);
                    if (solutionStep.getHaving() != null && resultData != null) {
                        Having having = solutionStep.getHaving();
                        List<FilterHavingChildren> newChildren = this.dealHavingChildren(having.getChildren(), computeList, context, stepIndex, solutionStep.getDatasetObject().getAlias());
                        JSONObject criteriaDefinition = new JSONObject();
                        criteriaDefinition.put("technique", (Object)"filter");
                        Filter filter = new Filter();
                        filter.setLogic(having.getLogic());
                        if (CollectionUtils.isNotEmpty(newChildren)) {
                            filter.setChildren(newChildren);
                            criteriaDefinition.put("schema", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)filter)));
                            JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
                            LOGGER.info("filterStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                            dataMap = new HashMap();
                            dataMap.put(dataKey, resultData);
                            TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                            TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
                            resultData = transEngine.runEngine(transDataManger);
                        }
                    }
                    SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                }
            }
            ArrayList<String> columnList = new ArrayList<String>();
            block14: for (Select select4 : selectList) {
                if (select4.getDataObject() == null) continue;
                String contentType = select4.getDataObject().getContentType();
                switch (contentType) {
                    case "const": {
                        columnList.add(select4.getDataObject().getAlias());
                        continue block14;
                    }
                    case "calculate": {
                        String computeName = select4.getDataObject().getContent();
                        JSONArray computeArray = solutionStep.getComputeList().getJSONArray(computeName);
                        String newField = computeArray.getJSONObject(computeArray.size() - 1).getString("newField");
                        columnList.add(newField);
                        continue block14;
                    }
                }
                columnList.add(select4.getDataObject().getContent());
            }
            if (!columnList.isEmpty()) {
                Object data = SolutionStepExecutionFacade.getTransDataMap().get(dataKey);
                JSONArray dataArray = JSONArray.parseArray((String)JSON.toJSONString((Object)data, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                JSONArray newDataArray = new JSONArray();
                for (int i = 0; i < dataArray.size(); ++i) {
                    JSONObject newJsonObject = new JSONObject();
                    JSONObject rowData = dataArray.getJSONObject(i);
                    Set keys = rowData.keySet();
                    for (String key : keys) {
                        if (!columnList.stream().anyMatch(key::equals)) continue;
                        newJsonObject.put(key, rowData.get((Object)key));
                    }
                    if (newJsonObject.isEmpty()) continue;
                    newDataArray.add((Object)newJsonObject);
                }
                SolutionStepExecutionFacade.getTransDataMap().put(dataKey, newDataArray);
            }
            if (CollectionUtils.isNotEmpty(solutionStep.getSort())) {
                ISolutionStepAnalyzer sortStep = (ISolutionStepAnalyzer)ContextUtils.getBean("sortStep", new Object[0]);
                sortStep.executeStep(solutionStep, stepIndex, context);
            } else if (solutionStep.getLimit() != null) {
                ISolutionStepAnalyzer limitStep = (ISolutionStepAnalyzer)ContextUtils.getBean("limitStep", new Object[0]);
                limitStep.executeStep(solutionStep, stepIndex, context);
            } else if (CollectionUtils.isNotEmpty(solutionStep.getUnion())) {
                ISolutionStepAnalyzer unionStep = (ISolutionStepAnalyzer)ContextUtils.getBean("unionStep", new Object[0]);
                unionStep.executeStep(solutionStep, stepIndex, context);
            } else {
                SolutionStepExecutionFacade.getTransDataMap().put(solutionStep.getAlias(), SolutionStepExecutionFacade.getTransDataMap().get(dataKey));
                SolutionStepExecutionFacade.getTransDataMap().remove(dataKey);
            }
        }
    }

    public Object doGroupTrans(JSONArray groupFields, JSONArray functionFields, Map<String, Object> dataMap, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("groupFields", (Object)groupFields);
        schema.put("functionFields", (Object)functionFields);
        JSONArray distinctFields = new JSONArray();
        for (int i = 0; i < functionFields.size(); ++i) {
            String methodName = functionFields.getJSONObject(i).getString("method");
            if (!"count,sum,average,min,max,group,variance,stddev,accSum".contains(methodName)) continue;
            distinctFields.add((Object)functionFields.getJSONObject(i).getString("newFields"));
        }
        distinctFields.addAll((Collection)groupFields);
        schema.put("distinctFields", (Object)distinctFields);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"group");
        criteriaDefinition.put("schema", (Object)schema);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("selectStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
        Object result = transEngine.runEngine(transDataManger);
        if (!distinctFields.isEmpty()) {
            distinctFields.addAll((Collection)groupFields);
            result = this.doDistinctTrans(distinctFields, result, context);
        }
        return result;
    }

    public Object doDistinctTrans(JSONArray distinctFields, Object data, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("distinctFields", (Object)distinctFields);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"distinct");
        criteriaDefinition.put("schema", (Object)schema);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("distinctStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, data, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
        return transEngine.runEngine(transDataManger);
    }

    public JSONArray createFunctionFields(List<String> computeKeys, JSONObject computeList) {
        JSONArray functionFields = new JSONArray();
        for (String computeKey : computeKeys) {
            JSONArray computeArray = computeList.getJSONArray(computeKey);
            List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
            if (computeArray.stream().anyMatch(compute -> {
                String functionName = ((JSONObject)compute).getString("calFunction");
                return methodList.contains(functionName.toUpperCase()) || functionName.equalsIgnoreCase("RowNumber");
            })) continue;
            for (int i = 0; i < computeArray.size(); ++i) {
                JSONObject compute2 = computeArray.getJSONObject(i);
                JSONObject function = new JSONObject();
                function.put("method", (Object)compute2.getString("calFunction").toLowerCase());
                JSONArray fields = new JSONArray();
                JSONArray parameters = compute2.getJSONArray("params");
                for (int j = 0; j < parameters.size(); ++j) {
                    JSONObject parameter = parameters.getJSONObject(j);
                    fields.add((Object)parameter.getString("content"));
                }
                function.put("fields", (Object)fields);
                function.put("valueType", (Object)compute2.getString("valueType"));
                function.put("newFields", (Object)compute2.getString("newField"));
                functionFields.add((Object)function);
            }
        }
        return functionFields;
    }

    public GroupBy doGroupCalculate(GroupBy groupBy, JSONObject computeList, Set<String> fieldKeys, Object data, SolutionStepContext context, String dataKey) {
        GroupBy newObject = new GroupBy();
        if (!"calculate".equals(groupBy.getContentType())) {
            return groupBy;
        }
        String computeName = groupBy.getContent();
        JSONArray newComputeJsonArray = new JSONArray();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeJsonArray.size(); ++i) {
            JSONObject compute = computeJsonArray.getJSONObject(i);
            String calFunction = compute.getString("calFunction");
            List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
            if (!methodList.contains(calFunction.toUpperCase())) {
                LOGGER.info("selectStep\u6267\u884cdoCalculate.trans\u4e2d\u8ba1\u7b97\u6682\u4e0d\u652f\u6301:{}", (Object)compute.getString("calFunction"));
                continue;
            }
            JSONArray parameters = compute.getJSONArray("params");
            boolean flag = false;
            for (int j = 0; j < parameters.size(); ++j) {
                JSONObject parameter = parameters.getJSONObject(j);
                if (fieldKeys.contains(parameter.getString("content")) || !"field".equals(parameter.getString("contentType"))) continue;
                flag = true;
                LOGGER.info("selectStep\u6267\u884cdoCalculate.trans\u4e2d\u8ba1\u7b97\u5217\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u96c6\u4e2d:{}", (Object)parameter.toJSONString());
            }
            if (flag) continue;
            newComputeJsonArray.add((Object)compute);
        }
        Object calculateResult = this.doCalculate(newComputeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doGroupCalculate\u6267\u884cdoCalculate.trans\u51fa\u53c2\u4e3anull");
            return groupBy;
        }
        JSONObject lastCalculateFunction = computeJsonArray.getJSONObject(computeJsonArray.size() - 1);
        newObject.setContent(lastCalculateFunction.getString("newField"));
        newObject.setSource(groupBy.getSource());
        newObject.setContentType("field");
        newObject.setDataType(lastCalculateFunction.getString("valueType"));
        newObject.setAlias(groupBy.getAlias());
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
        return newObject;
    }

    public void doSelectCalculate(Select select, JSONObject computeList, Object data, SolutionStepContext context, String dataKey) {
        if (select.getDataObject() == null) {
            return;
        }
        if (!"calculate".equals(select.getDataObject().getContentType())) {
            return;
        }
        String computeName = select.getDataObject().getContent();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int j = 0; j < computeJsonArray.size(); ++j) {
            String computeType = computeJsonArray.getJSONObject(j).getString("calFunction");
            List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
            if (methodList.contains(computeType.toUpperCase())) continue;
            return;
        }
        Object calculateResult = this.doCalculate(computeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doSelectCalculate\u6267\u884cdoCalculate.trans\u51fa\u53c2\u4e3anull");
            return;
        }
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
    }

    private Object doCalculate(JSONArray ruleJson, Object data, SolutionStepContext context) {
        JSONObject schema = new JSONObject();
        schema.put("rule", (Object)ruleJson);
        JSONObject criteriaDefinition = new JSONObject();
        criteriaDefinition.put("technique", (Object)"calculate");
        criteriaDefinition.put("schema", (Object)schema);
        JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
        LOGGER.info("selectStep\u6267\u884cdoCalculate.trans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
        TransDataManger transDataManger = new TransDataManger(jsonObject, data, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
        return transEngine.runEngine(transDataManger);
    }

    private List<FilterHavingChildren> dealHavingChildren(List<FilterHavingChildren> children, JSONObject computeList, SolutionStepContext context, int stepIndex, String alias) {
        ArrayList<FilterHavingChildren> newChildren = new ArrayList<FilterHavingChildren>();
        if (CollectionUtils.isEmpty(children)) {
            return newChildren;
        }
        for (FilterHavingChildren filterHavingChildren : children) {
            List<FilterHavingChildren> childChildren;
            FilterHavingChildren newChild = new FilterHavingChildren();
            newChild.setOperator(filterHavingChildren.getOperator());
            newChild.setLogic(filterHavingChildren.getLogic());
            BaseObject leftObject = this.createCalculateBaseObject(filterHavingChildren.getLeft(), computeList);
            if (leftObject != null) {
                newChild.setLeft(leftObject);
            }
            ArrayList<FilterHavingChildrenRight> newRightList = new ArrayList<FilterHavingChildrenRight>();
            List<FilterHavingChildrenRight> rightList = filterHavingChildren.getRight();
            for (FilterHavingChildrenRight filterHavingChildrenRight : rightList) {
                FilterHavingChildrenRight newChildRight = new FilterHavingChildrenRight();
                if (filterHavingChildrenRight.getDataObject() != null) {
                    BaseObject rightObject = this.createCalculateBaseObject(filterHavingChildrenRight.getDataObject(), computeList);
                    if (rightObject != null) {
                        newChildRight.setDataObject(rightObject);
                    } else {
                        newChildRight = null;
                    }
                } else {
                    DatasetObject datasetObject = filterHavingChildrenRight.getDatasetObject();
                    Object rightData = null;
                    if ("metric".equals(datasetObject.getDatasetType())) {
                        rightData = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
                    } else if ("step".equals(datasetObject.getDatasetType())) {
                        Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                        if (dataMap.containsKey(datasetObject.getStep())) {
                            rightData = dataMap.get(datasetObject.getStep());
                        }
                    } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                        DatasetObjectSolutionStepAnalyzer datasetObjectSolutionStepAnalyzer = (DatasetObjectSolutionStepAnalyzer)ContextUtils.getBean("datasetObjectStep", new Object[0]);
                        datasetObjectSolutionStepAnalyzer.executeStep(datasetObject.getSubQuery(), stepIndex, context);
                        Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                        String key = stepIndex + "-" + datasetObject.getSubQuery().getAlias();
                        if (dataMap.containsKey(key)) {
                            rightData = dataMap.get(key);
                        }
                    }
                    BaseObject baseObject = new BaseObject();
                    baseObject.setContent(JSONObject.toJSONString((Object)rightData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    baseObject.setSource(alias);
                    baseObject.setContent("const");
                    baseObject.setDataType("string");
                    newChildRight.setDataObject(baseObject);
                }
                if (newChildRight == null) continue;
                newRightList.add(newChildRight);
            }
            if (CollectionUtils.isNotEmpty(newRightList)) {
                newChild.setRight(newRightList);
            }
            if (CollectionUtils.isNotEmpty(childChildren = this.dealHavingChildren(filterHavingChildren.getChildren(), computeList, context, stepIndex, alias))) {
                newChild.setChildren(childChildren);
            }
            if (newChild.getLeft() == null || !CollectionUtils.isNotEmpty(newChild.getRight())) continue;
            newChildren.add(newChild);
        }
        return newChildren;
    }

    private BaseObject createCalculateBaseObject(BaseObject baseObject, JSONObject computeList) {
        BaseObject newBaseObject = new BaseObject();
        if ("calculate".equals(baseObject.getContentType())) {
            newBaseObject = new BaseObject();
            JSONArray computeArray = computeList.getJSONArray(baseObject.getContent());
            JSONObject lastComputeJson = computeArray.getJSONObject(computeArray.size() - 1);
            String newFieldName = lastComputeJson.getString("newField");
            newBaseObject.setContent(newFieldName);
            newBaseObject.setContentType("field");
            newBaseObject.setSource(baseObject.getSource());
            newBaseObject.setDataType(baseObject.getDataType());
            return newBaseObject;
        }
        BeanUtils.copyProperties((Object)baseObject, (Object)newBaseObject);
        return newBaseObject;
    }

    public String doRowNumberCalculate(String computeName, JSONObject computeList, Set<String> fieldKeys, Object data, SolutionStepContext context, String dataKey) {
        String newFieldName = null;
        if (!computeList.containsKey((Object)computeName)) {
            return null;
        }
        JSONArray newComputeJsonArray = new JSONArray();
        JSONArray computeJsonArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeJsonArray.size(); ++i) {
            JSONObject compute = computeJsonArray.getJSONObject(i);
            String calFunction = compute.getString("calFunction");
            List methodList = Arrays.stream("WEEKOFYEAROFDATE,ADD,ABS,MINUS,MULTIPLY,DIVIDE,DATEDIFFINDAYS,NUMBEROFINTERVALBYDAY,PRECISION,FORMATDATE,ROOTING,POWER,GROWTHRATE,DATEFORMAT".split(",")).collect(Collectors.toList());
            if (!methodList.contains(calFunction.toUpperCase())) {
                LOGGER.info("selectStep\u6267\u884cdoRowNumberCalculate.trans\u4e2d\u8ba1\u7b97\u6682\u4e0d\u652f\u6301:{}", (Object)compute.getString("calFunction"));
                continue;
            }
            newFieldName = compute.getString("newField");
            JSONArray parameters = compute.getJSONArray("params");
            boolean flag = false;
            for (int j = 0; j < parameters.size(); ++j) {
                JSONObject parameter = parameters.getJSONObject(j);
                if (fieldKeys.contains(parameter.getString("content")) || !"field".equals(parameter.getString("contentType"))) continue;
                flag = true;
                LOGGER.info("selectStep\u6267\u884cdoRowNumberCalculate.trans\u4e2d\u8ba1\u7b97\u5217\u4e0d\u5b58\u5728\u4e8e\u6570\u636e\u96c6\u4e2d:{}", (Object)parameter.toJSONString());
            }
            if (flag) continue;
            newComputeJsonArray.add((Object)compute);
        }
        Object calculateResult = this.doCalculate(newComputeJsonArray, data, context);
        if (calculateResult == null) {
            LOGGER.info("selectStep.doRowNumberCalculate\u6267\u884cdoCalculate.trans\u51fa\u53c2\u4e3anull");
            return null;
        }
        SolutionStepExecutionFacade.getTransDataMap().put(dataKey, calculateResult);
        return newFieldName;
    }
}

