package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/15 9:29
 */
@Service("MechanismAction")
public class MechanismAction extends ActionBase {

    private static final Logger LOGGER = LoggerFactory.getLogger(MechanismAction.class);

    /**
     * 执行获取机制变量服务 并返回服务结果
     *
     * @param context
     * @param reqMap
     * @param actionParam
     * @return
     */
    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String variableName = metaObj.getString(MetaDataConstant.ACTION_MECHANISM_VARIABLE_NAME);
        String eocLevel = metaObj.getString(MetaDataConstant.ACTION_MECHANISM_EOC_LEVEL);
        try {
            Map<String, Object> param = buildRequestBody(context,variableName,eocLevel);
            LOGGER.info("执行引擎调用themeMap获取{}机制变量入参:{}", actionParam.getActionId(), param);
            Map<String, String> header = new HashMap<>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            header.put(FieldNameConstant.USER_TOKEN, context.getToken());
            header.put(FieldNameConstant.SECURITY_TOKEN, context.getSecurityToken());
            header.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, context.getRouterKey());
            String httpRespContent = HttpClientUtils.doRequest("POST", ModuleProperty.THEMEMAP_ACTION_MECHANISM_NEW, header, param);

            LOGGER.info("执行引擎调用themeMap获取{}机制变量返回结果:{}", actionParam.getActionId(), httpRespContent);

            JSONObject respData = ServiceResponseUtils.getThemeMapResp(httpRespContent);

            if (respData != null) {
                context.setExecuteStatus(true);
            } else {
                context.setExecuteStatus(false);
                return null;
            }

            Map<String, Object> resultMap = new HashMap<>();
            resultMap.put(variableName, Optional.ofNullable(respData).map(data -> data.get(variableName)).orElse(null));

            return resultMap;
        } catch (Exception e) {
            LOGGER.error("执行获取机制变量[{}]调用异常:{}", variableName, e);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0003");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.GET_VAR);
            context.setExecuteErrorMessage(executeErrorMessage);
            context.setExecuteStatus(false);
            throw e;
        }
    }

    /**
     * 构建请求体
     *
     * @param context 上下文
     * @param variableName
     * @param eocLevel
     * @return
     */
    private Map<String, Object> buildRequestBody(ExecuteContext context, String variableName, String eocLevel) {
        Map<String, Object> result = new HashMap<>(2);
        Map<String, Object> queryData = new HashMap<>(8);
        queryData.put(FieldNameConstant.MECHANISM_QUERY_DATA_VARIABLE_NAME, variableName);
        queryData.put(FieldNameConstant.TENANT_ID, context.getTenantId());
        Map<String, Object> eocMap = context.getInputParam().getEocMap();
        // 传eoc的需要同时满足如下条件：1. eocMap不为空 2. eocLevel不为空
        if (MapUtils.isNotEmpty(eocMap) && StringUtils.isNotBlank(eocLevel)) {
            queryData.put(FieldNameConstant.MECHANISM_QUERY_DATA_EOC_MAP, eocMap);
        }
        if (MapUtils.isNotEmpty(eocMap) && MapUtils.isNotEmpty((Map) eocMap.get("operation_unit_v2"))) {
            queryData.put(FieldNameConstant.MECHANISM_QUERY_DATA_EOC_MAP, eocMap);
        }
        queryData.put(FieldNameConstant.MECHANISM_QUERY_DATA_EOC_LEVEL, eocLevel);
        result.put(FieldNameConstant.MECHANISM_QUERY_DATA, queryData);
        return result;
    }

}
