package com.digiwin.athena.executionengine.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;

/**
 * @description: 适用于调用第三方组件返回异常的场景。例如：HTTP调用状态码（4xx，5xx）异常，RPC调用异常等。
 * @author: ZhangJun
 * @date: 2022/1/6 15:02
 */
public class ResponseStatusException extends DWRuntimeException {

    @Override
    public String getErrorType() {
        return "application";
    }

    /**
     * 构造一个基本异常.
     *
     * @param code    错误码
     * @param message 信息描述
     */
    public ResponseStatusException(String code, String message) {
        super(code, message);
    }

    public ResponseStatusException(String errorCode, String message, String... messageArgs) {
        super(errorCode, message, messageArgs);
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     * @param cause   根异常类（可以存入任何异常）
     */
    public ResponseStatusException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * 构造一个基本异常.
     *
     * @param errorCode 错误码
     * @param message   信息描述
     * @param cause     根异常类（可以存入任何异常）
     */
    public ResponseStatusException(String errorCode, String message, Throwable cause) {
        super(errorCode, message, cause);
    }

}
