package com.digiwin.athena.executionengine.model;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.enumtype.ValueTypeEnum;

import java.util.List;

/**
 * @description: 参数属性实体类
 * @author: renwm
 * @date: 2020/5/18 14:24
 */
public class ParamElement {

    /**
     * 参数对应的 actionId
     */
    private String actionId;

    /**
     * 该参数是入参的时候，该参数来自入参哪个部分
     * 取值：CommonConstant.EXECUTION_PARAM/CommonConstant.EXECUTION_SYSPARAM
     */
    private String inputParamPart;

    /**
     * 参数的名称
     */
    private String paramName;

    /**
     * 参数类型
     */
    private ValueTypeEnum valueType;

    /**
     * 元素是否是数组
     */
    private Boolean isArray;
    /**
     * 元素的jsonpath 表达式
     */
    private String elementJsonPath;
    /**
     * 元素的节点路径
     */
    private String paramPath;

    /**
     * 父元素
     */
    private ParamElement parentElement;
    /**
     * 子元素
     */
    private List<ParamElement> childElements;

    /**
     * 字段是否必传，其区别仅当取值为null时，非必传则不传该字段，必传则传null
     */
    private Boolean isRequired;

    /**
     * 是否是主键字段，数据中主键字段一定是唯一的或者唯一的组合
     */
    private Boolean isDataKey;

    private BMDQuerySchema querySchema;

    public String getInputParamPart() {
        return inputParamPart;
    }

    public void setInputParamPart(String inputParamPart) {
        this.inputParamPart = inputParamPart;
    }

    public Boolean getIsRequired() {
        return isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public Boolean getIsDataKey() {
        return isDataKey;
    }

    public void setIsDataKey(Boolean isDataKey) {
        this.isDataKey = isDataKey;
    }

    public String getActionId() {
        return actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public String getParamName() {
        return paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public ValueTypeEnum getValueType() {
        return valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public Boolean getArray() {
        return isArray;
    }

    public void setArray(Boolean array) {
        isArray = array;
    }

    public String getElementJsonPath() {
        return elementJsonPath;
    }

    public void setElementJsonPath(String elementJsonPath) {
        this.elementJsonPath = elementJsonPath;
    }

    public String getParamPath() {
        return paramPath;
    }

    public void setParamPath(String paramPath) {
        this.paramPath = paramPath;
    }

    public ParamElement getParentElement() {
        return parentElement;
    }

    public void setParentElement(ParamElement parentElement) {
        this.parentElement = parentElement;
    }

    public List<ParamElement> getChildElements() {
        return childElements;
    }

    public void setChildElements(List<ParamElement> childElements) {
        this.childElements = childElements;
    }

    public BMDQuerySchema getQuerySchema() {
        return querySchema;
    }

    public void setQuerySchema(BMDQuerySchema querySchema) {
        this.querySchema = querySchema;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this, SerializerFeature.WRITE_MAP_NULL_FEATURES);
    }
}
