package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.LogConstant;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.DatasetObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Join;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("joinStep")
public class JoinSolutionStepAnalyzer implements ISolutionStepAnalyzer {

    private static final Logger LOGGER = LoggerFactory.getLogger(JoinSolutionStepAnalyzer.class);

    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {

    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        List<Join> joinList = solutionStep.getJoin();
        for (Join join : joinList) {
            Object joinData = null;
            DatasetObject datasetObject = join.getDatasetObject();
            if ("metric".equals(datasetObject.getDatasetType())) {
                joinData = SolutionStepExecutionFacade.getMetricData(datasetObject.getAlias());
            } else if ("step".equals(datasetObject.getDatasetType())) {
                Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                if (dataMap != null && dataMap.containsKey(datasetObject.getStep())) {
                    joinData = dataMap.get(datasetObject.getStep());
                }
            } else if ("subQuery".equals(datasetObject.getDatasetType())) {
                //调用上一步骤，递归执行
                DatasetObjectSolutionStepAnalyzer datasetObjectSolutionStepAnalyzer = ContextUtils.getBean("datasetObjectStep");
                datasetObjectSolutionStepAnalyzer.executeStep(datasetObject.getSubQuery(), stepIndex, context);
                Map<String, Object> dataMap = SolutionStepExecutionFacade.getTransDataMap();
                String key = stepIndex + "-" + datasetObject.getSubQuery().getAlias();
                if (dataMap != null && dataMap.containsKey(key)) {
                    joinData = dataMap.get(key);
                }
            }
            String leftDataKey = stepIndex + "-" + solutionStep.getAlias();
            Object leftData = SolutionStepExecutionFacade.getTransDataMap() != null
                    && SolutionStepExecutionFacade.getTransDataMap().containsKey(leftDataKey)
                    ? SolutionStepExecutionFacade.getTransDataMap().get(leftDataKey) : null;
            Object resultData = null;
            LOGGER.info("joinStep开始join操作joinData==null:{}，leftData==null:{}", joinData == null ? "true" : "false", leftData == null ? "true" : "false");
            if (joinData != null || leftData != null) {
                Map<String, Object> dataMap = new HashMap<>();
                dataMap.put("DATA1", leftData == null ? new ArrayList<>() : leftData);
                dataMap.put("DATA2", joinData == null ? new ArrayList<>() : joinData);
                JSONObject criteriaDefinition = new JSONObject();
                criteriaDefinition.put("technique", "join");
                criteriaDefinition.put("schema", JSONObject.parseObject(JSONObject.toJSONString(join)));
                JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
                LOGGER.info("joinStep执行trans入参:{}", JSONObject.toJSONString(jsonObject));
                TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
                resultData = transEngine.runEngine(transDataManger);
            }
            SolutionStepExecutionFacade.getTransDataMap().put(leftDataKey, resultData);
        }
        if (solutionStep.getFilter() != null) {
            ISolutionStepAnalyzer filterStep = ContextUtils.getBean("filterStep");
            filterStep.executeStep(solutionStep, stepIndex, context);
        } else {
            ISolutionStepAnalyzer selectStep = ContextUtils.getBean("selectStep");
            selectStep.executeStep(solutionStep, stepIndex, context);
        }
    }
}
