package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import org.apache.commons.text.StringSubstitutor;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/2/26
 */
public class ReplaceUtils {
    public static <T> String replace(Map<String, T> valueMap, String template) {
        StringSubstitutor stringSubstitutor = new StringSubstitutor(valueMap, CommonConstant.CLIENT_PLACEHOLDER_DEFAULT_PREFIX
                , CommonConstant.CLIENT_PLACEHOLDER_DEFAULT_SUFFIX);
        return stringSubstitutor.replace(template);
    }


    public static String replace(JSONObject valueMap, String template) {
        Map<String, Object> newMap = new HashMap<>();
        newMap.putAll(valueMap);
        return replace(newMap, template);
    }
}
