/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.schema.grammar;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SortConvertor
extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        Object dynamicSchema = schemaTransDto.getDynamicSchema();
        if (dynamicSchema == null) {
            return;
        }
        JSONArray sort = null;
        if (dynamicSchema instanceof JSONArray) {
            sort = (JSONArray)dynamicSchema;
        } else if (dynamicSchema instanceof List) {
            sort = JSONArray.parseArray((String)JSONObject.toJSONString((Object)schemaTransDto.getDynamicSchema()));
        }
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        Map<String, String> mapping = this.getReversalShowFieldMapping(querySchema);
        boolean fieldMatch = sort.stream().map(o -> (JSONObject)o).map(item -> item.getJSONObject("dataObject")).anyMatch(item -> mapping.containsKey(item.getString("content")));
        if (!fieldMatch) {
            return;
        }
        JSONArray newSort = new JSONArray();
        sort.forEach(item -> {
            JSONObject jsonObject = (JSONObject)item;
            JSONObject dataObject = jsonObject.getJSONObject("dataObject");
            String field = dataObject.getString("content");
            String order = jsonObject.getString("order");
            String showField = (String)mapping.get(field);
            JSONObject sortSchemaObj = new JSONObject();
            if (StringUtils.isNotBlank((CharSequence)showField)) {
                sortSchemaObj.put("field", (Object)showField);
                sortSchemaObj.put("order", (Object)order);
            }
            newSort.add((Object)sortSchemaObj);
        });
        querySchema.getJSONArray("sortFields").addAll((Collection)newSort);
    }
}

