package com.digiwin.athena.executionengine;

import com.digiwin.loadbalance.scan.DWPathScan;
import com.jugg.agile.framework.core.dapper.alarm.JaNotify;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

/**
 * @author wangbaojun
 * @since 2025/8/04
 */

@ComponentScan(basePackages = {"com.digiwin.gateway",
    "com.digiwin.athena.executionengine"})
@EnableScheduling
@EnableAsync
@EnableRetry
@SpringBootApplication(exclude = MongoAutoConfiguration.class)
@DWPathScan(basePackage = "com.digiwin.athena.*")
public class EngineAppBoot {
    public static void main(String[] args) throws Throwable {
        JaNotify.notifyRun(() -> {
            SpringApplication springApplication = new SpringApplication(EngineAppBoot.class);
            springApplication.addListeners(
                new ApplicationPidFileWriter("DWApiGatewayApplication.pid"));
            springApplication.run(args);
        });
        }
    }

