package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.client.impl.ThemeMapClient;
import com.digiwin.athena.executionengine.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/11/18
 */
@Service("BizParamAction")
public class BizParamAction extends ActionBase {

    private static final Logger LOGGER = LoggerFactory.getLogger(BizParamAction.class);

    private ThemeMapClient themeMapClient;

    @Resource
    public void setThemeMapClient(ThemeMapClient themeMapClient) {
        this.themeMapClient = themeMapClient;
    }

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        if (metaObj.containsKey("bizParamMeta") && !metaObj.getJSONObject("bizParamMeta").isEmpty()) {
            LOGGER.info("BizParamAction 获取EE业务变量的bizParamMeta为:{}", metaObj);
            JSONObject dataJson = new JSONObject();
            List<String> commonVarParamList = new ArrayList<>();
            JSONObject bizParamMetas = metaObj.getJSONObject("bizParamMeta");
            String paramName = bizParamMetas.getString("paramName");
            String paramValue = bizParamMetas.getString("paramValue");
            String paramType = bizParamMetas.getString("paramType");
            if ("system".equals(paramType)) {
                //系统变量
                switch (paramValue) {
                    case "s_runTime":
                        paramValue = DateUtils.getCurrentDateTime("yyyy-MM-dd HH:mm:ss");
                        break;
                    case "s_runDate":
                        paramValue = DateUtils.getCurrentDateTime("yyyy-MM-dd");
                        break;
                    case "s_userName":
                        paramValue = (String) context.getInputParam().getSysParam().get("loginUserName");
                        break;
                    case "s_userId":
                        paramValue = (String) context.getInputParam().getSysParam().get("userId");
                        break;
                }
                dataJson.put(paramName, paramValue);
            } else {
                //调用km接口获取业务变量的key
                commonVarParamList.add(paramValue);
            }
            if (!commonVarParamList.isEmpty()) {
                //需要调用km接口取值
                LOGGER.info("BizParamAction EE需要调用km获取业务变量值：{} 为获取到设定值", String.join(",", commonVarParamList));
                JSONObject respData = themeMapClient.querySmartDataVariable(context.getTenantId(), commonVarParamList, context.getToken());
                for (String commonVarParam : commonVarParamList) {
                    if (respData.containsKey(commonVarParam)) {
                        JSONObject commonVarParamJson = respData.getJSONObject(commonVarParam);
                        String status = commonVarParamJson.getString("status");
                        if ("1".equals(status)) {
                            dataJson.put(paramName, commonVarParamJson.get("value"));
                        } else {
                            LOGGER.info("BizParamAction EE获取业务变量：{} 未启用或者未设定值", commonVarParam);
                        }
                    }
                }
            }
            return dataJson;
        }
        return null;
    }
}
