package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.ResponseStatusException;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

/**
 * @description: IAM
 * @author: renwm
 * @date: 2020/7/7 17:11
 */
@Service("IamAction")
public class IamAction extends ActionBase {

    private static final Logger LOGGER = LoggerFactory.getLogger(IamAction.class);

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String url = metaObj.getString(MetaDataConstant.ACTION_URL);

        JSONObject actionJson = actionParam.getActionJson();
        String allocateType = actionJson.getString(MetaDataConstant.ACTION_ALLOCATE_TYPE);

        try {
            ServiceModel iamModel = new ServiceModel();
            iamModel.setToken(context.getToken());
            iamModel.setInvokeURL(url);
            iamModel.setParams(reqMap);
            iamModel.setRequestMethod(DWRequestMethod.POST);

            HttpResponseModel responseModel = (HttpResponseModel) IAMService.invoke(iamModel);
            LOGGER.info("执行引擎调用IAM执行{}:{}返回的结果为：{}", url, reqMap, responseModel.getResponseBody());

            if (ModuleProperty.RESPONSE_SUCCESS_STATUS == responseModel.getHttpStatusCode()) {
                context.setExecuteStatus(true);
                String result = String.format("{\"responseBody\":%s}", responseModel.getResponseBody());
                if (MetaDataConstant.ACTION_ALLOCATETYPE.equals(allocateType)) {
                    JSONArray jsonArray = JSON.parseArray(responseModel.getResponseBody());

                    if (null != jsonArray && jsonArray.size() > 1) {
                        result = JSON.toJSONString(jsonArray.get(ThreadLocalRandom.current().nextInt(jsonArray.size() - 1)));
                    }
                }
                return JSON.parseObject(result);
            }
        } catch (Exception e) {
            LOGGER.error("执行引擎触发IAM[{}]异常:{}", url, e);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0002");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.IAM);
            context.setExecuteErrorMessage(executeErrorMessage);
            context.setExecuteStatus(false);
            throw new ResponseStatusException(ErrorCodeEnum.CALL_IAM_EXCEPTION.getCode()
                    , ErrorCodeEnum.CALL_IAM_EXCEPTION.getMessage(), e);
        }
        return null;
    }
}
