package com.digiwin.athena.executionengine.constant;

/**
 * @description: 属性名称常量类
 * @author: renwm
 * @date: 2020/4/27 9:08
 */
public final class FieldNameConstant {


    private FieldNameConstant() {
    }


    /**
     * 租户sid 字段名称；是tenantSid依據tenantid產生的流水識別碼
     */
    public static final String TENANT_SID = "tenantSid";

    /**
     * 租户Id字段名称，tenantId是由租戶自行定義的識別名稱
     */
    public static final String TENANT_ID = "tenantId";
    /**
     * 语言别参数
     */
    public static final String LOCALE = "locale";

    /**
     * header透传 驼峰
     */
    public static final String CAMEL_CASE_ROUTER_KEY = "routerKey";
    public static final String SOURCE = "source";


    /**
     * 租户名称字段名
     */
    public static final String TENANT_NAME = "tenantName";

    /**
     * 用户id 字段名
     */
    public static final String USER_ID = "userId";

    /**
     * 用户名  字段名称
     */
    public static final String USER_NAME = "userName";

    /**
     * 用户token  字段名称
     */
    public static final String USER_TOKEN = "token";

    /**
     * app token
     */
    public static final String APP_TOKEN = "digi-middleware-auth-app";

    /**
     * application 资源文件名字
     */
    public static final String APPLICATION_PROPERTIES_NAME = "application";


    /**
     * IAM 登录 入参 secretKey 字段名称
     */
    public static final String SECRETKEY_KEY = "secretKey";

    /**
     * IAM 登录 入参 identityType 字段名称
     */
    public static final String IDENTITY_TYPE_KEY = "identityType";


    public static final String DATA = "data";

    public static final String VALUE = "value";

    /**
     * 平台返回响应结果 response 字段名称
     */
    public static final String DW_SERVICE_RESPONSE = "response";
    public static final String DW_SERVICE_STATUS = "status";

    /**
     * esp  std_data 字段名
     */
    public static final String ESP_STD_DATA = "std_data";

    /**
     * esp  parameter字段名
     */
    public static final String ESP_PARAMETER = "parameter";

    /**
     * esp  execution字段名
     */
    public static final String ESP_EXECUTION = "execution";

    /**
     * esp  code字段名
     */
    public static final String ESP_CODE = "code";


    /**
     * theme map 返回结果  状态的字段
     */
    public static final String THEMEMAP_SERVICE_SUCCESS = "success";

    /**
     * theme map 返回结果 结果的字段
     */
    public static final String THEMEMAP_SERVICE_DATA = "data";

    /**
     * paras 执行引擎的业务入参，以JSONArray表现
     */
    public static final String INPUT_PARAM_PARAS = "paras";

    /**
     * param 执行引擎的业务入参，以JSONObject表现
     */
    public static final String INPUT_PARAM_PARAM = "param";

    /**
     * sysParam 执行引擎系统参数，以JSONObject表现
     */
    public static final String INPUT_PARAM_SYSPARAM = "sysParam";

    public static final boolean isValidInputParamPath(String inputParamPath) {
        if (INPUT_PARAM_PARAM.equals(inputParamPath) || INPUT_PARAM_PARAS.equals(inputParamPath) || INPUT_PARAM_SYSPARAM.equals(inputParamPath)) {
            return true;
        }
        return false;
    }

    /**
     * km获取变量接口的入参
     */
    public static final String VARIABLE_IDS = "variableIds";

    /**
     * 机制变量的serviceName
     */
    public static final String VARIABLE_SERVICE_NAME = "Mechanism";

    /**
     * 机制变量的methodName
     */
    public static final String VARIABLE_METHOD_NAME = "getVariable";

    /**
     * LicenseKey的serviceName
     */
    public static final String LICENSEKEY_SERVICE_NAME = "app";

    /**
     * LicenseKey的methodName
     */
    public static final String LICENSEKEY_METHOD_NAME = "getLicenseKey";

    /**
     * 信任链
     */
    public static final String SECURITY_TOKEN = "security-token";

    /**
     * 排序列
     */
    public static final String TRANS_SORT_LINENUMBER = "lineNumber";

    public static final String MECHANISM_QUERY_DATA = "queryData";
    public static final String MECHANISM_QUERY_DATA_VARIABLE_NAME = "variableName";
    public static final String MECHANISM_QUERY_DATA_EOC_MAP = "eocMap";
    public static final String MECHANISM_QUERY_DATA_EOC_LEVEL = "eocLevel";
    /**
     * poc 语义提供的动态查询方案传入执行引擎的key
     */
    public static final String DYNAMIC_SCHEMA_DEFINE = "dynamic_schema_definition";
    public static final String DYNAMIC_SCHEMA_DIMENSIONS = "dimensions";
    public static final String DYNAMIC_SCHEMA_FILTER = "filter";
    public static final String DYNAMIC_SCHEMA_MEASURES = "measures";
    public static final String DYNAMIC_SCHEMA_CONTENT_TYPE = "contentType";
    public static final String DYNAMIC_SCHEMA_FIELD = "field";
    public static final String DYNAMIC_SCHEMA_CALCULATE = "calculate";
    public static final String DYNAMIC_SCHEMA_SHOWFIELDSMAPPING = "showFieldsMapping";
    public static final String DYNAMIC_SCHEMA_COMPUTELIST = "computeList";
    public static final String DYNAMIC_SCHEMA_CONTENT = "content";


}