package com.digiwin.athena.executionengine.core.aop;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author zhangjun
 * @date 2021-09-08 15:18
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ExceptionRetry {
    /**
     * 重试次数
     *
     * @return
     */
    int times() default 1;

    /**
     * 重试等待时间 单位ms
     *
     * @return
     */
    long waitTime() default 100;

}
