package com.digiwin.athena.executionengine.enumtype;

/**
 * @description: action 参数类型
 * @author: renwm
 * @date: 2020/6/12 17:31
 */
public enum ParamTypeEnum {

    /**
     * pulling
     */
    PULLING("PULLING","PullingParam","source请求参数"),
    PARAM("PARAM","InputParam","入参"),
    SYS_PARAM("SYSPARAM","InputParam","入参"),
    CONSTANT("CONSTANT","ConstantParam","常量参数"),
    CASE("CASE","CaseParam","case类型的参数"),
    MULTI_PATH("MULTIPATH","MultiPathParam","多路径类型的参数"),
    PROCESSED_PARAM("PROCESSED_PARAM","Processed_Param","需要经过加工处理的参数，如MicroTrans"),
    /**
     * 未知类型
     */
    UNKNOWN("UNKNOWN", "","未知类型");

    String type;
    String desc;
    String className;
    ParamTypeEnum(String type, String className, String desc) {
        this.type = type;
        this.className = className;
        this.desc = desc;
    }

    public static ParamTypeEnum getEnumByType(String type) {
        for (ParamTypeEnum itemEnum : ParamTypeEnum.values()) {

            if (itemEnum.getType().equals(type)) {
                return itemEnum;
            }
        }
        return UNKNOWN;
    }


    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getClassName() {
        return className;
    }
}
