package com.digiwin.athena.executionengine.model.solutionStep;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Filter;
import com.digiwin.athena.executionengine.model.input.SolutinStep.GroupBy;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Having;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Select;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Sort;

import java.util.List;
import java.util.Map;

/**
 * metric数据
 */
public class SolutionStepMetric {

    private String key;

    /**
     * 对应的别名，唯一的
     */
    private String alias;

    /**
     * 指标id
     */
    private String metric;

    private Filter filter;

    private Having having;

    private List<Select> select;

    private List<GroupBy> groupBy;

    private JSONObject computeList;

    private List<Sort> sort;

    /**
     * 最开始获取的时候count++
     * 后期执行的时候取一次count-- 为0则删除数据
     */
    private Integer count;

    /**
     * 获取到的数据
     */
    private Object data;

    /**
     * 指标的json字符串，用于比较是否为同一个Metric
     * ****目前先使用alias判断取的指标数据是否相同****
     */
    private String jsonStr;

    /**
     * 数据中台模型id模型id
     */
    private String modelId;

    /**
     * 数据中台模型id模型id
     */
    private String modelCode;

    public String getModelCode() {
        return modelCode;
    }

    public void setModelCode(String modelCode) {
        this.modelCode = modelCode;
    }

    public List<Select> getSelect() {
        return select;
    }

    public void setSelect(List<Select> select) {
        this.select = select;
    }

    public String getModelId() {
        return modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Integer getCount() {
        return count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getJsonStr() {
        return jsonStr;
    }

    public void setJsonStr(String jsonStr) {
        this.jsonStr = jsonStr;
    }

    public String getMetric() {
        return metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public Filter getFilter() {
        return filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Having getHaving() {
        return having;
    }

    public void setHaving(Having having) {
        this.having = having;
    }

    public List<GroupBy> getGroupBy() {
        return groupBy;
    }

    public void setGroupBy(List<GroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public JSONObject getComputeList() {
        return computeList;
    }

    public void setComputeList(JSONObject computeList) {
        this.computeList = computeList;
    }

    public List<Sort> getSort() {
        return sort;
    }

    public void setSort(List<Sort> sort) {
        this.sort = sort;
    }
}
