package com.digiwin.athena.executionengine.model.trans;

/**
 * @description: 数据逻辑判断规则
 * @author: zhangww
 * @date: 2021/1/5 11:25
 */
public class NumberRangeRuleElement {

    /**
     * 下限
     */
    private String lower;

    /**
     * 描述lower的类型，可以不填，不填时默认lower为constant
     * constant：lower的值为常量值
     * var：lower为机制变量的key（用法同filter中的var类型取值）
     */
    private String lowerType;

    /**
     * 取值为：number、boolean,不填默认为number类型
     */
    private String lowerDataType;

    private String calcType;

    /**
     * 上限
     */
    private String upper;

    /**
     * 描述upper的类型，可以不填，不填时默认upper为constant
     * constant：upper的值为常量值
     * var：upper为机制变量的key（用法同filter中的var类型取值）
     */
    private String upperType;

    /**
     * 取值为：number、boolean,不填默认为number类型
     */
    private String upperDataType;

    /**
     * 取值
     */
    private String value;

    /**
     * value的数据类型，当valueType为常量值时有效，可以不填，不填时默认为string
     * string：字符串
     * number：数字类型
     */
    private String valueDataType;

    /**
     * 判断类型
     */
    private String decision;

    /**
     * 算法参数A
     */
    String fieldA;

    /**
     * 算法参数B
     */
    String fieldB;

    /**
     * 算法参数C
     */
    String fieldC;

    /**
     * 参数A字符串格式化结构
     */
    String formatA;

    /**
     * 参数B字符串格式化结构
     */
    String formatB;

    /**
     * 参数C字符串格式化结构
     */
    String formatC;

    /**
     * 算法参数A来源 column or constant
     */
    String fieldAType;

    /**
     * 算法参数B来源 column or constant
     */
    String fieldBType;

    /**
     * 算法参数C来源 column or constant
     */
    String fieldCType;

    /**
     * 节点计算最终结果存储字段的字段名
     */
    String newField;

    /**
     * 节点计算最终结果的数据类型
     */
    String valueType;

    /**
     * 节点计算最终结果的数据长度，超过长度会截断（暂未启用）
     */
    String valueLength;

    /**
     * 节点计算最终结果的数据精度，超过长度会截断（暂未启用）
     * 并不是向下取整，而是截断
     */
    String precision;

    /**
     * 输出结果中是否保留该字段
     */
    String retain;

    /**
     * 间隔天数
     */
    private int intervalDays;

    /**
     * 取整类型
     * 向上取整、向下取整、四舍五入
     */
    private String precisionType;

    public String getPrecisionType() {
        return precisionType;
    }

    public void setPrecisionType(String precisionType) {
        this.precisionType = precisionType;
    }

    public int getIntervalDays() {
        return intervalDays;
    }

    public void setIntervalDays(int intervalDays) {
        this.intervalDays = intervalDays;
    }

    public String getCalcType() {
        return calcType;
    }

    public void setCalcType(String calcType) {
        this.calcType = calcType;
    }

    public String getFieldA() {
        return fieldA;
    }

    public void setFieldA(String fieldA) {
        this.fieldA = fieldA;
    }

    public String getFieldB() {
        return fieldB;
    }

    public void setFieldB(String fieldB) {
        this.fieldB = fieldB;
    }

    public String getFieldC() {
        return fieldC;
    }

    public void setFieldC(String fieldC) {
        this.fieldC = fieldC;
    }

    public String getFormatA() {
        return formatA;
    }

    public void setFormatA(String formatA) {
        this.formatA = formatA;
    }

    public String getFormatB() {
        return formatB;
    }

    public void setFormatB(String formatB) {
        this.formatB = formatB;
    }

    public String getFormatC() {
        return formatC;
    }

    public void setFormatC(String formatC) {
        this.formatC = formatC;
    }

    public String getNewField() {
        return newField;
    }

    public void setNewField(String newField) {
        this.newField = newField;
    }

    public String getValueType() {
        return valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getValueLength() {
        return valueLength;
    }

    public void setValueLength(String valueLength) {
        this.valueLength = valueLength;
    }

    public String getPrecision() {
        return precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public String getRetain() {
        return retain;
    }

    public void setRetain(String retain) {
        this.retain = retain;
    }

    public String getLower() {
        return lower;
    }

    public void setLower(String lower) {
        this.lower = lower;
    }

    public String getUpper() {
        return upper;
    }

    public void setUpper(String upper) {
        this.upper = upper;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDecision() {
        return decision;
    }

    public void setDecision(String decision) {
        this.decision = decision;
    }

    public String getFieldAType() {
        return fieldAType;
    }

    public void setFieldAType(String fieldAType) {
        this.fieldAType = fieldAType;
    }

    public String getFieldBType() {
        return fieldBType;
    }

    public void setFieldBType(String fieldBType) {
        this.fieldBType = fieldBType;
    }

    public String getFieldCType() {
        return fieldCType;
    }

    public void setFieldCType(String fieldCType) {
        this.fieldCType = fieldCType;
    }

    public String getLowerType() {
        return lowerType;
    }

    public void setLowerType(String lowerType) {
        this.lowerType = lowerType;
    }

    public String getUpperType() {
        return upperType;
    }

    public void setUpperType(String upperType) {
        this.upperType = upperType;
    }

    public String getValueDataType() {
        return valueDataType;
    }

    public void setValueDataType(String valueDataType) {
        this.valueDataType = valueDataType;
    }

    public String getLowerDataType() {
        return lowerDataType;
    }

    public void setLowerDataType(String lowerDataType) {
        this.lowerDataType = lowerDataType;
    }

    public String getUpperDataType() {
        return upperDataType;
    }

    public void setUpperDataType(String upperDataType) {
        this.upperDataType = upperDataType;
    }
}
