package com.digiwin.athena.executionengine.provider;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.action.EspAction;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/6/16
 */
public class TestService implements ITestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestService.class);

    @Autowired
    private EspAction espAction;

    @Override
    public Object testEspAction(JSONObject pRequest) {

        InputParamModule inputParam = new InputParamModule();
        inputParam.setTenantId(pRequest.get("tenantId").toString());
        Map<String, Object> eocMap = new HashMap<>();
        inputParam.setEocMap(eocMap);
        //String token = pRequest.get("token").toString();
        ExecuteContext context = new ExecuteContext(inputParam, DWServiceContext.getContext().getToken());
        context.setLocale("zh_CN");
        //pRequest.get("routeKey").toString()
        context.setRouterKey((String) DWServiceContext.getContext().getRequestHeader().get("routeKey"));

        Map<String, Object> reqMap = new HashMap<>();

        String actionId = "test";
        String actionName = "test";
        String actionType = "test";
        JSONObject metaObj = new JSONObject();
        metaObj.put("serviceName", pRequest.get("serviceName"));
        JSONObject actionJson = new JSONObject();
        actionJson.put("productName", pRequest.get("productName"));
        ActionParam actionParam = new ActionParam(actionId, actionName, actionType, metaObj);
        actionParam.setActionJson(actionJson);
        return espAction.actionExecute(context, reqMap, actionParam);
    }

}
