package com.digiwin.athena.executionengine.service.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.athena.executionengine.constant.*;
import com.digiwin.athena.executionengine.service.client.IIAMClient;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service("engineIAMClient")
public class IAMClient implements IIAMClient {

    private static final Logger LOGGER = LoggerFactory.getLogger(IAMClient.class);

    /**
     * 根据用户token获取用户详细信息
     *
     * @param token   token
     * @param withEmp 是否查询员工信息
     * @return json
     */
    @Override
    public JSONObject getUserInfoByToken(String token, boolean withEmp) {
        try {
            ServiceModel iamModel = new ServiceModel();
            iamModel.setToken(token);
            iamModel.setInvokeURL(ModuleProperty.IAM_USERINFO_URL + withEmp);
            iamModel.setRequestMethod(DWRequestMethod.GET);
            iamModel.setApplicationToken(ModuleProperty.MULTIPLEAPPENV?ModuleProperty.MERGED_IAM_APP_TOKEN:ModuleProperty.APP_TOKEN_VALUE);

            HttpResponseModel responseModel = (HttpResponseModel) IAMService.invoke(iamModel);
            if (ModuleProperty.RESPONSE_SUCCESS_STATUS == responseModel.getHttpStatusCode()) {
                return JSON.parseObject(responseModel.getResponseBody());
            }
        } catch (Exception e) {
            LOGGER.error(String.format(LogConstant.AGILE_DATA + "getUserInfoByToken:%s ", "IAMClient", e));
        }
        return null;
    }
}
