package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Sort;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("sortStep")
public class SortSolutionStepAnalyzer implements ISolutionStepAnalyzer {

    private static final Logger LOGGER = LoggerFactory.getLogger(SortSolutionStepAnalyzer.class);

    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {

    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object sortData = SolutionStepExecutionFacade.getTransDataMap() != null
                && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey)
                ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("sortStep开始执行sortData==null:{}", sortData == null ? "true" : "false");
        JSONArray sortDataArray = JSONArray.parseArray(JSONObject.toJSONString(sortData, SerializerFeature.WriteMapNullValue));
        if (sortDataArray != null && !sortDataArray.isEmpty()) {
            Map<String, Object> dataMap = new HashMap<>();
            dataMap.put(dataKey, sortDataArray);
            JSONObject criteriaDefinition = new JSONObject();
            criteriaDefinition.put("technique", "sorts");
            JSONObject sortJson = new JSONObject();
            List<Sort> newSortList = new ArrayList<>();
            for (Sort sort : solutionStep.getSort()) {
                Sort newSort = new Sort();
                BeanUtils.copyProperties(sort, newSort);
                if ("calculate".equals(sort.getDataObject().getContentType())) {
                    String content = newSort.getDataObject().getContent();
                    newSort.getDataObject().setContent(getComputeColumnName(solutionStep.getComputeList(), content));
                    newSortList.add(newSort);
                } else if ("field".equals(sort.getDataObject().getContentType())) {
                    //判断是否在select中
                    String content = sort.getDataObject().getContent();
                    JSONObject data = sortDataArray.getJSONObject(0);
                    Set<String> dataFieldKeys = data.keySet();
                    if (dataFieldKeys.contains(content)) {
                        newSortList.add(newSort);
                    }
                }
            }
            Object resultData;
            if (CollectionUtils.isNotEmpty(newSortList)) {
                sortJson.put("sort", JSONArray.parseArray(JSONArray.toJSONString(newSortList)));
                criteriaDefinition.put("schema", sortJson);
                JSONObject jsonObject = transDefinitionConvertor.convert(criteriaDefinition);
                LOGGER.info("sortStep执行trans入参:{}", JSONObject.toJSONString(jsonObject));
                TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
                resultData = transEngine.runEngine(transDataManger);
            } else {
                resultData = sortData;
            }
            if (solutionStep.getLimit() != null) {
                SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                ISolutionStepAnalyzer limitStep = ContextUtils.getBean("limitStep");
                limitStep.executeStep(solutionStep, stepIndex, context);
            } else if (CollectionUtils.isNotEmpty(solutionStep.getUnion())) {
                ISolutionStepAnalyzer unionStep = ContextUtils.getBean("unionStep");
                unionStep.executeStep(solutionStep, stepIndex, context);
            } else {
                SolutionStepExecutionFacade.getTransDataMap().put(solutionStep.getAlias(), resultData);
                SolutionStepExecutionFacade.getTransDataMap().remove(dataKey);
            }
        }
    }

    private String getComputeColumnName(JSONObject computeList, String computeName) {
        JSONArray computeArray = computeList.getJSONArray(computeName);
        for (int i = 0; i < computeArray.size(); i++) {
            JSONObject compute = computeArray.getJSONObject(i);
            return compute.getString("newField");
        }
        return "";
    }
}
