package com.digiwin.athena.executionengine.service.facade.convert;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.core.container.PocContext;
import com.digiwin.athena.executionengine.model.step.IStep;
import com.digiwin.athena.executionengine.model.step.MetricsStep;
import org.springframework.stereotype.Service;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/6/14
 */
@Service("metrics")
public class MetricsConvertor implements IDefinitionConvertor {
    @Override
    public void convert(IStep step, PocContext pocContext) {
        MetricsStep metricsStep = (MetricsStep) step;

        JSONObject define = new JSONObject();
        define.put(FieldNameConstant.DYNAMIC_SCHEMA_DIMENSIONS, metricsStep.getDynamicDimensions());
        define.put(FieldNameConstant.DYNAMIC_SCHEMA_FILTER, metricsStep.getDynamicFilter());
        define.put(FieldNameConstant.DYNAMIC_SCHEMA_MEASURES, metricsStep.getDynamicMeasure());
        pocContext.getDefine().put(metricsStep.getStep(), define);


    }
}
