package com.digiwin.athena.executionengine.service.facade.data.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.bo.DataCenterParamBo;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.dto.DataCenterDto;
import com.digiwin.athena.executionengine.model.BasePage;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.model.solutionStep.SolutionStepMetric;
import com.digiwin.athena.executionengine.service.client.IDataCenterClient;
import com.digiwin.athena.executionengine.service.facade.data.IScraper;
import com.digiwin.athena.executionengine.service.facade.schema.ISchemaBuilder;
import com.digiwin.athena.executionengine.vo.MetricResultVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2025/5/14
 */
@Service("dataset")
public class DatasetScraper implements IScraper {
    @Autowired
    private ISchemaBuilder schemaBuilder;

    @Autowired
    private IDataCenterClient dataCenterClient;

    @Override
    public MetricResultVo fetchData(SolutionStepMetric metric, SolutionStepContext context) {
        DataDescription dataDescription = new DataDescription();
        JSONObject dynamicSchema = new JSONObject();
        dynamicSchema.put("groupBy", CollectionUtils.isEmpty(metric.getGroupBy()) ? null : JSONArray.parseArray(JSONArray.toJSONString(metric.getGroupBy())));
        dynamicSchema.put("filter", metric.getFilter() == null || CollectionUtils.isEmpty(metric.getFilter().getChildren()) ? null : JSONObject.parseObject(JSONObject.toJSONString(metric.getFilter())));
        dynamicSchema.put("having", metric.getHaving() == null || CollectionUtils.isEmpty(metric.getHaving().getChildren()) ? null : JSONObject.parseObject(JSONObject.toJSONString(metric.getHaving())));
        dynamicSchema.put("computeList", metric.getComputeList() == null || metric.getComputeList().isEmpty() ? null : metric.getComputeList());
        dynamicSchema.put("sort", CollectionUtils.isEmpty(metric.getSort()) ? null : JSONArray.parseArray(JSONObject.toJSONString(metric.getSort())));
        dynamicSchema.put("select", JSONArray.parseArray(JSONObject.toJSONString(metric.getSelect())));
        dynamicSchema.put("fieldMapping", context.getDatasetFieldsMapping().get(metric.getMetric()));
        dataDescription.setDynamicSchema(dynamicSchema);

        dataDescription.setDatasetPermissions(getRow(context.getPermissions()));
        DataCenterParamBo dataCenterParamBo = schemaBuilder.buildDataCenterSchema(dataDescription);
        JSONArray dataCenterData = dataCenterClient.getDataCenterData(buildDataCenterParam(metric, context, dataCenterParamBo));
        JSONObject data = new JSONObject();
        data.put("data", dataCenterData);
        return new MetricResultVo(data, null);
    }



    /**
     * 获取行权限
     *
     * @param permissions
     * @return
     */
    private JSONArray getRow(Map<String, Object> permissions) {
        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(permissions));
        if (jsonObject.containsKey("rows") && !CollectionUtils.isEmpty(jsonObject.getJSONArray("rows"))) {
            return jsonObject.getJSONArray("rows");
        }
        return null;
    }

    private DataCenterDto buildDataCenterParam(SolutionStepMetric metric, SolutionStepContext context, DataCenterParamBo dataCenterParamBo) {
        DataCenterDto dataCenterDto = new DataCenterDto();
        dataCenterDto.setPageSize(BasePage.DEFAULT_PAGE_SIZE);
        dataCenterDto.setPageNo(1);
        dataCenterDto.setQuerySchema(dataCenterParamBo.getQuerySchema());
        dataCenterDto.setOrderColumn(CollectionUtils.isEmpty(dataCenterParamBo.getOrderColumn()) ? null : dataCenterParamBo.getOrderColumn());
        dataCenterDto.setModelId(metric.getModelId());
        dataCenterDto.setModelCode(metric.getModelCode());
        dataCenterDto.setToken(context.getToken());
        dataCenterDto.setRouterKey(context.getTenantId());
        return dataCenterDto;
    }
}
