package com.digiwin.athena.executionengine.service.facade.execution;

import com.digiwin.athena.executionengine.dto.ExportDataDto;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.model.input.SolutionStepInput;

import java.util.List;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/6/4
 */
public interface ISolutionStepExecutionFacade {
    /**
     * solutionStep执行
     *
     * @param solutionStepInput ADE调用入参
     * @return obj
     */
    Object execute(SolutionStepInput solutionStepInput);

    /**
     * 进行指标分析，以及步骤处理
     *
     * @param solutionStep      步骤
     * @param context           权限及基础信息
     * @param solutionStepIndex 步骤序号
     */
    void doSolutionStep(SolutionStep solutionStep, SolutionStepContext context, int solutionStepIndex);

    /**
     * 指标明细导出
     *
     * @param solutionStepInput
     * @return
     */
    List<ExportDataDto> export(SolutionStepInput solutionStepInput);
}
