package com.digiwin.athena.executionengine.service.facade.mapping.data;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.constant.MetaDefinitionConstant;
import com.digiwin.athena.executionengine.model.MetaDataResponse;
import com.digiwin.athena.executionengine.model.MetaDataResponseData;
import com.digiwin.athena.executionengine.util.JsonUtil;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @description:
 * @author:fenglei
 * @date:20240122
 */
public class MetaGenerator {

    private DataMappingHandler dataMappingHandler;
    private String actionId;

    public MetaGenerator(DataMappingHandler dataMappingHandler) {
        this.dataMappingHandler = dataMappingHandler;
    }

    public MetaGenerator(DataMappingHandler dataMappingHandler, String actionId) {
        this.dataMappingHandler = dataMappingHandler;
        this.actionId = actionId;
    }

    public JSONObject generate() {
        Set<String> leafParamPath = dataMappingHandler.getLeafParamPath();
        Set<String> nodeIdList = new HashSet<>();
        List<Map<String, Object>> responseMetas = new ArrayList<>(leafParamPath.size());
        for (String paramPath : leafParamPath) {
            Map<String, Object> responseMeta = new HashMap<>();
            dataMappingHandler.getDataNodeByParamPath(paramPath);
            responseMetas.add(generate(paramPath, responseMeta, nodeIdList));
        }

        Map<String, Object> data = new HashMap<>(6);
        data.put("data_name", "data");
        data.put("data_type", "object");
        data.put("required", "true");
        data.put("is_datakey", null);
        data.put("is_array", false);
        data.put("field", responseMetas);

        Map<String, Object> response = new HashMap<>(1);
        response.put("data", data);

        Map<String, Object> meta = new HashMap<>();
        meta.put("actionId", actionId);
        meta.put("request", new HashMap<>());
        meta.put("response", response);
        meta.put("name", null);
        meta.put("sceneNodeType", null);

        return JSONObject.parseObject(JsonUtil.getJsonString(meta));
    }

    private Map<String, Object> generate(String paramPath, Map<String, Object> childMetaNode, Set<String> nodeIdList) {

        if (dataMappingHandler.isRootNode(paramPath)) {
            return childMetaNode;
        } else {
            DataNode dataNode = dataMappingHandler.getDataNodeByParamPath(paramPath);

            if (nodeIdList.contains(dataNode.getNodeId())) {
                return childMetaNode;
            }
            nodeIdList.add(paramPath);
            Map<String, Object> meta = generateMetaDefineNode(dataNode);
            if (!CollectionUtils.isEmpty(childMetaNode)) {
                generateMetaChildrenNode(meta, childMetaNode);
            }
            String parentParamPath = dataMappingHandler.getParentParamPath(paramPath);
            return generate(parentParamPath, meta, nodeIdList);
        }
    }

    private Map<String, Object> generateMetaDefineNode(DataNode dataNode) {
        Map<String, Object> metaDefineNode = new HashMap<>();

        metaDefineNode.put(MetaDefinitionConstant.DATA_NAME, dataNode.getNodeName());
        metaDefineNode.put(MetaDefinitionConstant.DATA_TYPE, "string");
        metaDefineNode.put(MetaDefinitionConstant.REQUIRED, "true");
        metaDefineNode.put(MetaDefinitionConstant.IS_DATAKEY, null);
        metaDefineNode.put(MetaDefinitionConstant.IS_ARRAY, dataNode.isArray()?"true":"false");
        metaDefineNode.put(MetaDefinitionConstant.IS_BUSINESSKEY, "false");
        metaDefineNode.put(MetaDefinitionConstant.CAN_SORT, "false");
        metaDefineNode.put(MetaDefinitionConstant.CAN_FILTER, "false");
        metaDefineNode.put(MetaDefinitionConstant.PERCENT, null);
        metaDefineNode.put(MetaDefinitionConstant.DECIMAL, null);
        metaDefineNode.put(MetaDefinitionConstant.FIELD, null);
        metaDefineNode.put(MetaDefinitionConstant.DESCRIPTION, "");

        return metaDefineNode;
    }

    private void generateMetaChildrenNode(Map<String, Object> meta, Map<String, Object> metaNode) {
        if (meta.get(MetaDefinitionConstant.FIELD) == null) {
            List<Object> fieldsMeta = new ArrayList<>();
            fieldsMeta.add(metaNode);
            meta.put(MetaDefinitionConstant.FIELD, fieldsMeta);
        } else {
            List fields = (List<Object>)meta.get(MetaDefinitionConstant.FIELD);
            fields.add(metaNode);
        }
    }

    public JSONObject merge(JSONObject newMeta, JSONObject orgMeta) {
        /**
         * DATA_NAME和IS_ARRAY、precision、enum_key字段不能覆盖，其他直接覆盖
         *         metaDefineNode.put(MetaDefinitionConstant.DATA_TYPE, "string");
         *         metaDefineNode.put(MetaDefinitionConstant.REQUIRED, "true");
         *         metaDefineNode.put(MetaDefinitionConstant.IS_DATAKEY, null);
         *         metaDefineNode.put(MetaDefinitionConstant.IS_BUSINESSKEY, "false");
         *         metaDefineNode.put(MetaDefinitionConstant.CAN_SORT, "false");
         *         metaDefineNode.put(MetaDefinitionConstant.CAN_FILTER, "false");
         *         metaDefineNode.put(MetaDefinitionConstant.PERCENT, null);
         *         metaDefineNode.put(MetaDefinitionConstant.DECIMAL, null);
         *         metaDefineNode.put(MetaDefinitionConstant.FIELD, null);
         *         metaDefineNode.put(MetaDefinitionConstant.DESCRIPTION, "");
         */
        if(orgMeta.get(MetaDataConstant.DATA_ACTION_METADATAS) != null && !CollectionUtils.isEmpty((Collection) orgMeta.get(MetaDataConstant.DATA_ACTION_METADATAS))){
            List<Map<String, Object>> metadatas = (List<Map<String, Object>>) orgMeta.get(MetaDataConstant.DATA_ACTION_METADATAS);
            for(Map<String, Object> metadata : metadatas){
                if(metadata.get(MetaDataConstant.ACTION_ACTION_ID).equals(newMeta.get(MetaDataConstant.ACTION_ACTION_ID))){
                    //首先拿过来元数据的request直接覆盖过来
                    newMeta.put(MetaDataConstant.METADATAS_ACTION_REQUEST, metadata.get(MetaDataConstant.METADATAS_ACTION_REQUEST));
                    //接下来比较两种数据的结构
                    MetaDataResponseData newResponseData = JsonUtil.getObject(JsonUtil.getJsonString(newMeta.get(MetaDataConstant.METADATAS_ACTION_RESPONSE)), MetaDataResponse.class).getData();
                    MetaDataResponseData orgResponseData = JsonUtil.getObject(JsonUtil.getJsonString(metadata.get(MetaDataConstant.METADATAS_ACTION_RESPONSE)), MetaDataResponse.class).getData();
                    if(newResponseData.getData_name().equals(orgResponseData.getData_name())){
                        newResponseData.buildMetaDataResponseData(orgResponseData);
                        //接下来是塞field
                        buildField(newResponseData.getField(), orgResponseData.getField());
                    }
                    MetaDataResponse response = new MetaDataResponse();
                    response.setData(newResponseData);
                    newMeta.put(MetaDataConstant.METADATAS_ACTION_RESPONSE, response);
                }
            }

        }else {
            //元数据没有定义，或者没有拿到，直接返回新的元数据
            return newMeta;
        }
        return newMeta;
    }

    private void buildField(List<MetaDataResponseData> newResponseDataField, List<MetaDataResponseData> orgResponseDataField) {
        for(MetaDataResponseData newField : newResponseDataField){
            for(MetaDataResponseData orgfield : orgResponseDataField){
                if(newField.getData_name().equals(orgfield.getData_name())){
                    newField.buildMetaDataResponseData(orgfield);
                    if(!CollectionUtils.isEmpty(newField.getField())){
                        buildField(newField.getField(), orgfield.getField());
                    }
                    break;
                }
            }
        }
    }


}

