package com.digiwin.athena.executionengine.service.facade.schema.dynamic;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.model.input.SolutinStep.GroupBy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2025/2/13
 */
@Service
public class GroupBuilder extends AbstractDynamicCalculateBuilder {

    /**
     * 用设计器的度量+语义给的维度，进行group
     *
     * @param dynamicSchema 语义动态schema
     * @param actionParam   action param
     * @return
     */
    @Override
    public JSONObject build(Object dynamicSchema, ActionParam actionParam) {
        if (actionParam.getAggregation() == null) {
            return null;
        }
        //取语义的维度
        List<GroupBy> groupByList = JSONArray.parseArray(JSONArray.toJSONString(dynamicSchema), GroupBy.class);
        JSONArray fields = new JSONArray();
        JSONObject actionResFieldsMapping = actionParam.getStandardParameterMapping();
        for (GroupBy groupBy : groupByList) {
            if (keyExists(groupBy.getContent(), actionResFieldsMapping)) {
                fields.add(groupBy.getContent());
            }
        }
        //处理度量-取设计器的度量
        JSONArray measures = actionParam.getAggregation().getJSONArray("measures");
        JSONArray statistics = new JSONArray();
        for (int j = 0; j < measures.size(); j++) {
            JSONObject measure = measures.getJSONObject(j);
            JSONObject statistic = new JSONObject();
            statistic.put("mode", "normal");
            statistic.put("statisticalMethod", measure.getString("extractionFunction"));
            statistic.put("type", "number");
            JSONArray statisticalFields = new JSONArray();
            statisticalFields.add(measure.getString("data_name"));
            statistic.put("statisticalFields", statisticalFields);
            statistics.add(statistic);
        }
        if (!CollectionUtils.isEmpty(statistics)) {
            JSONObject recast = new JSONObject();
            recast.put("name", "group");
            recast.put("technique", "group");
            JSONObject condition = new JSONObject();
            condition.put("fields", fields);
            condition.put("statistics", statistics);
            recast.put("condition", condition);
            return recast;
        } else {
            return null;
        }
    }
}
