package com.digiwin.athena.executionengine.service.facade.schema.grammar;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.dto.schema.LeftDto;
import com.digiwin.athena.executionengine.dto.schema.RightDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.model.action.FilterNode;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/13
 */
@Service
public class FilterConvertor extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        if (schemaTransDto.getDynamicSchema() == null) {
            return;
        }
        JSONObject filterObj = null;
        if (schemaTransDto.getDynamicSchema() instanceof JSONObject) {
            filterObj = (JSONObject) schemaTransDto.getDynamicSchema();
        } else if (schemaTransDto.getDynamicSchema() instanceof Map) {
            filterObj = JSONObject.parseObject(JSONObject.toJSONString(schemaTransDto.getDynamicSchema()));
        }
        JSONObject computeObj = JSONObject.parseObject(JSONObject.toJSONString(schemaTransDto.getComputeObj()));
        JSONObject querySchema = schemaTransDto.getQuerySchema();
        if (MapUtils.isEmpty(filterObj)) {
            return;
        }

        Map<String, String> mapping = getReversalShowFieldMapping(querySchema);
        FilterNode filterNode = processFilter(filterObj, computeObj, mapping);
        if (filterNode != null) {
            JSONObject filter = new JSONObject();
            JSONArray children = new JSONArray();
            filter.put("logical", "and");
            filter.put("children", children);
            children.add(querySchema.getJSONObject("filter"));
            children.add(JSONObject.toJSON(filterNode));
            querySchema.put(FieldNameConstant.DYNAMIC_SCHEMA_FILTER, filter);
        }

    }

    private FilterNode processFilter(JSONObject filter, JSONObject computeObj, Map<String, String> mapping) {
        FilterNode filterNode = new FilterNode();
        String logic = filter.getString("logic");
        if (filter.size() > 2) {
            LeftDto leftDto = getLeftDto(filter, computeObj);
            RightDto rightDto = getRightDto(filter, computeObj);

            if (leftDto == null || rightDto == null) {
                return null;
            }

            if (!mapping.containsKey(leftDto.getLeftField())) {
                return null;
            }



            filterNode.setLeftValue(mapping.get(leftDto.getLeftField()));
            filterNode.setOperator(CommonConstant.FILTER_TYPE_COMPARISON_MAP.get(filter.getString("operator")));
            filterNode.setRightValue(rightDto.getRightValue());
            filterNode.setRightType(rightDto.getFilterRightType());
            if (StringUtils.isNotEmpty(leftDto.getFunction())) {
                filterNode.setFieldFunctionFlag(true);
                filterNode.setFieldFunctionType(leftDto.getFunction());
                filterNode.setFunctionParams(leftDto.getFunctionParams());
            }

        }

        if (CollectionUtils.isNotEmpty(filter.getJSONArray("children"))) {
            filterNode.setLogical(logic);
            JSONArray children = filter.getJSONArray("children");
            for (int i = 0; i < children.size(); i++) {
                JSONObject child = children.getJSONObject(i);
                FilterNode childNode = processFilter(child, computeObj, mapping);
                if (childNode != null) {
                    filterNode.getChildren().add(childNode);
                }
            }
        }
        return filterNode;
    }

    private RightDto getRightDto(JSONObject filter, JSONObject computeObj) {
        JSONArray rights = filter.getJSONArray("right");
        if (CollectionUtils.isEmpty(rights)) {
            return null;
        }
        JSONObject rightObj = rights.getJSONObject(0);

        JSONObject dataObject = rightObj.getJSONObject("dataObject");
        if (MapUtils.isEmpty(dataObject)) {
            return null;
        }

        String contentType = dataObject.getString("contentType");

        if (!"const".equals(contentType)) {
            return null;
        }
        List<String> collect = rights.stream().map(item -> (JSONObject) item).map(obj -> obj.getJSONObject("dataObject").getString("content")).collect(Collectors.toList());
        String rightValue = collect.stream().collect(Collectors.joining(","));

        //String rightValue = dataObject.getString("content");

        return new RightDto(rightValue, contentType);
    }

    private LeftDto getLeftDto(JSONObject filter, JSONObject computeObj) {
        JSONObject left = filter.getJSONObject("left");
        String contentType = left.getString("contentType");
        String content = left.getString("content");
        //左值类型支支持field 和 calculate类型
        if ("calculate".equals(contentType)) {
            //寻找计算函数以及计算列 目前只支持dataformat
            JSONArray computeList = computeObj.getJSONArray(content);
            JSONObject compute = computeList.getJSONObject(0);

            String field = compute.getJSONArray("params").getJSONObject(0).getString("content");
            String function = compute.getJSONArray("params").getJSONObject(1).getString("contentType");
            String type = compute.getJSONArray("params").getJSONObject(1).getString("content");

            return new LeftDto(field, contentType, function.toLowerCase(), type);
        }
        return new LeftDto(content, contentType);
    }
}
