package com.digiwin.athena.executionengine.util;

import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.exception.CustomException;
import com.digiwin.athena.executionengine.exception.ResponseStatusException;
import com.digiwin.athena.executionengine.exception.VerificationException;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/9/8
 */
public class ExceptionUtils {

    /**
     * 构造BusinessException
     *
     * @param errorCode
     * @param params
     * @return
     */
    public static BusinessException buildBusinessException(ErrorCodeEnum errorCode, String... params) {
        return new BusinessException(errorCode.getCode(),errorCode.getMessage(), params);
    }


    /**
     * 构造CustomException
     *
     * @param errorCode
     * @param params
     * @return
     */
    public static CustomException buildCustomException(ErrorCodeEnum errorCode, String... params) {
        return new CustomException(errorCode.getCode(),errorCode.getMessage(), params);
    }

    /**
     * 构造VerificationException
     *
     * @param errorCode
     * @param params
     * @return
     */
    public static VerificationException buildVerificationException(ErrorCodeEnum errorCode, String... params) {
        return new VerificationException(errorCode.getCode(),errorCode.getMessage(), params);
    }

    /**
     * ResponseStatusException
     *
     * @param errorCode
     * @param params
     * @return
     */
    public static ResponseStatusException buildResponseStatusException(ErrorCodeEnum errorCode, String... params) {
        return new ResponseStatusException(errorCode.getCode(),errorCode.getMessage(), params);
    }

}
