package com.digiwin.athena.executionengine.util;

import org.springframework.core.io.ClassPathResource;
import org.springframework.util.StreamUtils;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/2/26
 */
public class FileReadUtils {
    /**
     * 根据fileName读取文件内容
     *
     * @param fileName
     * @return
     */
    public static String readFile(String fileName) {
        String content;
        try {
            ClassPathResource classPathResource = new ClassPathResource("template/" + fileName + ".txt");
            content = StreamUtils.copyToString(classPathResource.getInputStream(), StandardCharsets.UTF_8);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return content;
    }
}
